/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.effect;

import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.network.CMessageEffectFinished;
import ovh.corail.tombstone.network.CMessageEffectStarted;
import ovh.corail.tombstone.network.PacketHandler;

public class TombstoneEffect
extends MobEffect {
    private boolean noAttributeScale = false;
    private boolean isInstantenous = false;
    private boolean requireSync = false;

    public TombstoneEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void onEffectStarted(LivingEntity livingEntity, int amplifier) {
        if (this.requireSync && !livingEntity.level().isClientSide() && livingEntity.isAlive()) {
            @Nullable MobEffectInstance effectInstance = livingEntity.getActiveEffectsMap().entrySet().stream().filter(entry -> ((MobEffectInstance)entry.getValue()).getEffect().value() == this).findFirst().map(Map.Entry::getValue).orElse(null);
            Optional.ofNullable(effectInstance).ifPresent(e -> PacketHandler.sendToAllTrackingPlayers(new CMessageEffectStarted(livingEntity.getId(), effectInstance), livingEntity));
        }
    }

    public void onEffectFinished(LivingEntity livingEntity, MobEffectInstance effectInstance) {
        if (this.requireSync && !livingEntity.level().isClientSide() && livingEntity.isAlive()) {
            PacketHandler.sendToAllTrackingPlayers(new CMessageEffectFinished(livingEntity.getId(), (Holder<MobEffect>)effectInstance.getEffect()), livingEntity);
        }
    }

    public void addAttributeModifiers(AttributeMap attributeMap, int amplifier) {
        super.addAttributeModifiers(attributeMap, this.noAttributeScale ? 0 : amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean isInstantenous() {
        return this.isInstantenous;
    }

    public TombstoneEffect setInstantenous() {
        this.isInstantenous = true;
        return this;
    }

    public TombstoneEffect noAttributeScale() {
        this.noAttributeScale = true;
        return this;
    }

    public boolean isRequiringSync() {
        return this.requireSync;
    }

    public TombstoneEffect requireSync() {
        this.requireSync = true;
        return this;
    }
}

