/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block.entity;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.TimeHelper;

public abstract class BlockEntityWritableGrave
extends BlockEntity {
    @Nullable
    private UUID ownerId = null;
    protected String ownerName = "";
    protected long deathDate;
    protected long deathMCTime = 0L;
    public long countTicks = 0L;

    public BlockEntityWritableGrave(BlockEntityType<?> tileType, BlockPos pos, BlockState state) {
        super(tileType, pos, state);
    }

    public boolean canShowFog() {
        return ((ConfigTombstone.Client.FogDensity)((Object)ConfigTombstone.client.fogDensity.get())).ordinal() != 0 && Optional.ofNullable(this.getLevel()).map(Helper::isNight).orElse(false) != false;
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, BlockEntityWritableGrave grave) {
        if (level.isClientSide() && grave.canShowFog() && grave.countTicks > 0L) {
            ProxyHelper.produceGraveSmoke(level, ((ConfigTombstone.Client.FogDensity)((Object)ConfigTombstone.client.fogDensity.get())).ordinal(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.4, (double)pos.getZ() + 0.5, TimeHelper.isDateAroundHalloween() ? 0xFFFFFF : (Integer)ConfigTombstone.client.fogColor.get());
        }
        ++grave.countTicks;
    }

    public void setOwner(@Nullable UUID ownerId, String ownerName, long deathDate) {
        this.ownerId = ownerId;
        this.ownerName = ownerName;
        this.deathDate = deathDate;
        Optional.ofNullable(this.getLevel()).ifPresent(l -> {
            this.deathMCTime = TimeHelper.worldTicks(l);
        });
    }

    public boolean isOwner(Player owner) {
        return Optional.ofNullable(this.ownerId).map(id -> id.equals(owner.getGameProfile().getId())).orElse(true);
    }

    @Nullable
    public UUID getOwnerId() {
        return this.ownerId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean hasOwner() {
        return !this.ownerName.isEmpty();
    }

    public long getDeathMCTime() {
        return Optional.ofNullable(this.getLevel()).map(l -> {
            long worldTicks = TimeHelper.worldTicks(l);
            if (this.deathMCTime > worldTicks) {
                this.deathMCTime = worldTicks;
            }
            return worldTicks - this.deathMCTime;
        }).orElse(0L);
    }

    public void resetDeathTime() {
        this.deathDate = TimeHelper.systemTime();
        this.countTicks = 0L;
        Optional.ofNullable(this.getLevel()).ifPresent(l -> {
            this.deathMCTime = TimeHelper.worldTicks(l);
        });
    }

    public long getOwnerDeathTime() {
        return this.deathDate;
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        this.writeShared(compound);
    }

    protected CompoundTag writeShared(CompoundTag compound) {
        if (this.ownerId != null) {
            compound.putUUID("owner_id", this.ownerId);
        }
        compound.putString("ownerName", this.ownerName);
        compound.putLong("deathDate", this.deathDate);
        compound.putLong("deathMCTime", this.deathMCTime);
        compound.putLong("countTicks", this.countTicks);
        return compound;
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (compound.hasUUID("owner_id")) {
            this.ownerId = compound.getUUID("owner_id");
        }
        if (compound.contains("ownerName", 8)) {
            this.ownerName = compound.getString("ownerName");
        }
        if (compound.contains("deathDate", 4)) {
            this.deathDate = compound.getLong("deathDate");
        }
        if (compound.contains("deathMCTime", 4)) {
            this.deathMCTime = compound.getLong("deathMCTime");
        }
        if (compound.contains("countTicks", 4)) {
            this.countTicks = compound.getLong("countTicks");
        } else if (compound.contains("countTicks", 3)) {
            this.countTicks = compound.getInt("countTicks");
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.writeShared(new CompoundTag());
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public boolean triggerEvent(int id, int type) {
        return true;
    }
}

