/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.item.module.DetectorModule;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;

public class CompiledDetectorModule
extends CompiledModule {
    private final DetectorSettings settings;

    public CompiledDetectorModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        this.settings = (DetectorSettings)stack.getOrDefault(ModDataComponents.DETECTOR_SETTINGS, (Object)DetectorSettings.DEFAULT);
    }

    @Override
    public boolean shouldExecute() {
        return true;
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        ItemStack stack = router.getBufferItemStack();
        if (!this.getFilter().test(stack)) {
            return false;
        }
        router.emitRedstone(this.getDirection(), this.getSignalLevel(), DetectorModule.SignalType.getType(this.isStrongSignal()));
        return true;
    }

    public int getSignalLevel() {
        return this.settings.signalLevel;
    }

    public boolean isStrongSignal() {
        return this.settings.strongSignal;
    }

    @Override
    public void onCompiled(ModularRouterBlockEntity router) {
        super.onCompiled(router);
        router.setAllowRedstoneEmission(true);
    }

    @Override
    public void cleanup(ModularRouterBlockEntity router) {
        super.cleanup(router);
        router.setAllowRedstoneEmission(false);
    }

    public record DetectorSettings(int signalLevel, boolean strongSignal) {
        public static final DetectorSettings DEFAULT = new DetectorSettings(15, false);
        public static final Codec<DetectorSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ExtraCodecs.intRange((int)0, (int)15).optionalFieldOf("signal_level", (Object)15).forGetter(DetectorSettings::signalLevel), (App)Codec.BOOL.optionalFieldOf("strong", (Object)false).forGetter(DetectorSettings::strongSignal)).apply((Applicative)builder, DetectorSettings::new));
        public static final StreamCodec<FriendlyByteBuf, DetectorSettings> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, DetectorSettings::signalLevel, (StreamCodec)ByteBufCodecs.BOOL, DetectorSettings::strongSignal, DetectorSettings::new);
    }
}

