/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.ModularRoutersTags;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.TranslatableEnum;
import me.desht.modularrouters.util.fake_player.RouterFakePlayer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class CompiledActivatorModule
extends CompiledModule {
    private final ActivatorSettings settings;
    private int entityIdx;
    private final Set<String> BLOCK_METHODS = ImmutableSet.of((Object)"onBlockActivated", (Object)"use");
    private final Set<String> ITEM_METHODS = ImmutableSet.of((Object)"onItemUseFirst", (Object)"onItemUse", (Object)"useOn", (Object)"onItemRightClick", (Object)"use");
    private static final Set<Item> itemBlacklist = new HashSet<Item>();
    private static final Set<Block> blockBlacklist = new HashSet<Block>();

    public CompiledActivatorModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        this.settings = (ActivatorSettings)stack.getOrDefault(ModDataComponents.ACTIVATOR_SETTINGS, (Object)ActivatorSettings.DEFAULT);
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        boolean didWork;
        ItemStack stack = router.getBufferItemStack();
        if (itemBlacklist.contains(stack.getItem())) {
            return false;
        }
        if (!stack.isEmpty() && !this.getFilter().test(stack) || stack.isEmpty() && !this.getFilter().isEmpty() && this.getFilter().isWhiteList()) {
            return false;
        }
        RouterFakePlayer fakePlayer = router.getFakePlayer();
        Vec3 centre = Vec3.atCenterOf((Vec3i)router.getBlockPos());
        fakePlayer.setPos(centre.x() + (double)this.getAbsoluteFacing().getStepX() * 0.501, centre.y() + (double)this.getAbsoluteFacing().getStepY() * 0.501, centre.z() + (double)this.getAbsoluteFacing().getStepZ() * 0.501);
        fakePlayer.setShiftKeyDown(this.settings.sneaking);
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, stack);
        switch (this.settings.actionType.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                boolean bl = this.doUseItem(router, fakePlayer);
                break;
            }
            case 1: {
                boolean bl = this.doUseItemOnEntity(router, fakePlayer);
                break;
            }
            case 2: {
                boolean bl = didWork = this.doAttackEntity(router, fakePlayer);
            }
        }
        if (didWork) {
            router.setBufferItemStack(fakePlayer.getMainHandItem());
            this.dropExtraItems(router, (Player)fakePlayer);
        }
        return didWork;
    }

    private boolean doUseItem(ModularRouterBlockEntity router, FakePlayer fakePlayer) {
        BlockPos pos = router.getBlockPos();
        Level world = Objects.requireNonNull(router.getLevel());
        ItemStack stack = router.getBufferItemStack();
        fakePlayer.setYRot((float)MiscUtil.getYawFromFacing(this.getAbsoluteFacing()));
        fakePlayer.setXRot(this.getAbsoluteFacing().getAxis() == Direction.Axis.Y ? (float)(this.getAbsoluteFacing().getStepY() * -90) : this.settings.lookDirection.pitch);
        BlockHitResult hitResult = this.doRayTrace(pos, fakePlayer);
        BlockState state = world.getBlockState(hitResult.getBlockPos());
        if (hitResult.getType() != HitResult.Type.MISS && blockBlacklist.contains(state.getBlock())) {
            return false;
        }
        try {
            return fakePlayer.gameMode.useItemOn((ServerPlayer)fakePlayer, world, stack, InteractionHand.MAIN_HAND, hitResult).consumesAction() || fakePlayer.gameMode.useItem((ServerPlayer)fakePlayer, world, stack, InteractionHand.MAIN_HAND).consumesAction();
        }
        catch (Exception e) {
            this.handleBlacklisting(stack, state, e);
            return false;
        }
    }

    private void handleBlacklisting(ItemStack stack, BlockState state, Exception e) {
        for (StackTraceElement el : e.getStackTrace()) {
            if (this.ITEM_METHODS.contains(el.getMethodName())) {
                ModularRouters.LOGGER.error("Attempting to use item {} threw an exception. Blacklisting this item for the Activator Module until next server restart!", (Object)stack);
                ModularRouters.LOGGER.error("Stacktrace:", (Throwable)e);
                itemBlacklist.add(stack.getItem());
                return;
            }
            if (!this.BLOCK_METHODS.contains(el.getMethodName())) continue;
            ModularRouters.LOGGER.error("Attempting to use block {} threw an exception. Blacklisting this block for the Activator Module until next server restart!", (Object)state);
            ModularRouters.LOGGER.error("Stacktrace:", (Throwable)e);
            blockBlacklist.add(state.getBlock());
            return;
        }
    }

    private BlockHitResult doRayTrace(BlockPos routerPos, FakePlayer fp) {
        Vec3 fpVec = fp.position();
        int xOff = this.getAbsoluteFacing().getStepX();
        int yOff = this.getAbsoluteFacing().getStepY();
        int zOff = this.getAbsoluteFacing().getStepZ();
        BlockPos.MutableBlockPos targetPos = routerPos.relative(this.getAbsoluteFacing()).mutable();
        LookDirection lookDirection = this.settings.lookDirection;
        if (lookDirection != LookDirection.LEVEL && Block.isShapeFullBlock((VoxelShape)fp.level().getBlockState((BlockPos)targetPos).getShape((BlockGetter)fp.level(), (BlockPos)targetPos))) {
            if (lookDirection == LookDirection.ABOVE) {
                fpVec = Vec3.atCenterOf((Vec3i)targetPos).add(0.0, 1.0, 0.0);
                yOff = -1;
            } else if (lookDirection == LookDirection.BELOW) {
                fpVec = Vec3.atCenterOf((Vec3i)targetPos).add(0.0, -1.0, 0.0);
                yOff = 1;
            }
        } else if (lookDirection == LookDirection.ABOVE) {
            targetPos.move(Direction.UP);
            yOff = 1;
        } else if (lookDirection == LookDirection.BELOW) {
            targetPos.move(Direction.DOWN);
            yOff = -1;
        }
        double reachDist = this.getRangeSquared();
        while (targetPos.distSqr((Vec3i)routerPos) <= reachDist) {
            VoxelShape shape;
            if (!fp.level().isEmptyBlock((BlockPos)targetPos) && !(shape = fp.level().getBlockState((BlockPos)targetPos).getShape((BlockGetter)fp.level(), (BlockPos)targetPos)).isEmpty()) {
                Vec3 targetVec = ((AABB)shape.toAabbs().getFirst()).getCenter().add(Vec3.atLowerCornerOf((Vec3i)targetPos));
                BlockHitResult res = fp.level().clip(new ClipContext(fpVec, targetVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.SOURCE_ONLY, (Entity)fp));
                if (res.getType() == HitResult.Type.BLOCK) {
                    return res;
                }
            }
            targetPos.move(xOff, yOff, zOff);
        }
        return BlockHitResult.miss((Vec3)fpVec.add(fp.getLookAngle()), (Direction)this.getAbsoluteFacing().getOpposite(), (BlockPos)routerPos.relative(this.getAbsoluteFacing()));
    }

    private boolean doAttackEntity(ModularRouterBlockEntity router, RouterFakePlayer fakePlayer) {
        LivingEntity entity;
        block3: {
            block2: {
                entity = this.findEntity(router, LivingEntity.class, this::passesAttackBlacklist);
                if (entity == null) break block2;
                if (!(entity instanceof Player)) break block3;
                Player p = (Player)entity;
                if (router.getUpgradeCount((UpgradeItem)ModItems.SECURITY_UPGRADE.get()) <= 0 || !router.isPermitted(p)) break block3;
            }
            return false;
        }
        fakePlayer.lookAt(EntityAnchorArgument.Anchor.EYES, entity.position());
        fakePlayer.attack((Entity)entity);
        return true;
    }

    private boolean doUseItemOnEntity(ModularRouterBlockEntity router, FakePlayer fakePlayer) {
        Entity entity = this.findEntity(router, Entity.class, this::passesUseBlacklist);
        if (entity == null) {
            return false;
        }
        InteractionResult result = fakePlayer.interactOn(entity, InteractionHand.MAIN_HAND);
        if (result.consumesAction()) {
            router.setBufferItemStack(fakePlayer.getMainHandItem());
            return true;
        }
        return false;
    }

    private <T extends Entity> T findEntity(ModularRouterBlockEntity router, Class<T> cls, Predicate<Entity> blacklistChecker) {
        Direction face = Objects.requireNonNull(this.getAbsoluteFacing());
        BlockPos pos = router.getBlockPos();
        Vec3 vec = Vec3.atCenterOf((Vec3i)pos);
        double expand = (double)this.getRange() / 2.0;
        double moveBy = expand + 0.5;
        AABB box = new AABB(vec, vec).move((double)face.getStepX() * moveBy, (double)face.getStepY() * moveBy, (double)face.getStepZ() * moveBy).inflate(expand);
        List l = Objects.requireNonNull(router.getLevel()).getEntitiesOfClass(cls, box, blacklistChecker);
        if (l.isEmpty()) {
            return null;
        }
        switch (this.settings.entityMode.ordinal()) {
            case 1: {
                return (T)((Entity)l.get(router.getLevel().random.nextInt(l.size())));
            }
            case 0: {
                l.sort(Comparator.comparingDouble(o -> o.distanceToSqr(vec)));
                return (T)((Entity)l.getFirst());
            }
            case 2: {
                l.sort(Comparator.comparingDouble(o -> o.distanceToSqr(vec)));
                this.entityIdx = (this.entityIdx + 1) % l.size();
                return (T)((Entity)l.get(this.entityIdx));
            }
        }
        return null;
    }

    private boolean passesAttackBlacklist(Entity e) {
        return !e.getType().is(ModularRoutersTags.EntityTypes.activatorAttackBlacklist);
    }

    private boolean passesUseBlacklist(Entity e) {
        return !e.getType().is(ModularRoutersTags.EntityTypes.activatorInteractBlacklist);
    }

    private void dropExtraItems(ModularRouterBlockEntity router, Player fakePlayer) {
        NonNullList inv = fakePlayer.getInventory().items;
        Vec3 where = Vec3.atCenterOf((Vec3i)router.getBlockPos().relative(this.getAbsoluteFacing()));
        Level level = Objects.requireNonNull(router.getLevel());
        for (int i = 1; i < inv.size() && !((ItemStack)inv.get(i)).isEmpty(); ++i) {
            ItemEntity item = new ItemEntity(level, where.x(), where.y(), where.z(), (ItemStack)inv.get(i));
            router.getLevel().addFreshEntity((Entity)item);
            inv.set(i, (Object)ItemStack.EMPTY);
        }
    }

    public ActionType getActionType() {
        return this.settings.actionType;
    }

    public LookDirection getLookDirection() {
        return this.settings.lookDirection;
    }

    public EntityMode getEntityMode() {
        return this.settings.entityMode;
    }

    public boolean isSneaking() {
        return this.settings.sneaking;
    }

    @Override
    public int getEnergyCost() {
        return this.settings.actionType == ActionType.ATTACK_ENTITY ? (Integer)ConfigHolder.common.energyCosts.activatorModuleEnergyCostAttack.get() : (Integer)ConfigHolder.common.energyCosts.activatorModuleEnergyCost.get();
    }

    @Override
    public boolean careAboutItemAttributes() {
        return this.settings.actionType == ActionType.ATTACK_ENTITY;
    }

    public record ActivatorSettings(ActionType actionType, LookDirection lookDirection, EntityMode entityMode, boolean sneaking) {
        public static final ActivatorSettings DEFAULT = new ActivatorSettings(ActionType.ITEM_OR_BLOCK, LookDirection.LEVEL, EntityMode.NEAREST, false);
        public static final Codec<ActivatorSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)StringRepresentable.fromEnum(ActionType::values).optionalFieldOf("action", (Object)ActionType.USE_ITEM_ON_ENTITY).forGetter(ActivatorSettings::actionType), (App)StringRepresentable.fromEnum(LookDirection::values).optionalFieldOf("look_direction", (Object)LookDirection.LEVEL).forGetter(ActivatorSettings::lookDirection), (App)StringRepresentable.fromEnum(EntityMode::values).optionalFieldOf("entity_mode", (Object)EntityMode.NEAREST).forGetter(ActivatorSettings::entityMode), (App)Codec.BOOL.optionalFieldOf("sneaking", (Object)false).forGetter(ActivatorSettings::sneaking)).apply((Applicative)builder, ActivatorSettings::new));
        public static final StreamCodec<FriendlyByteBuf, ActivatorSettings> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(ActionType.class), ActivatorSettings::actionType, (StreamCodec)NeoForgeStreamCodecs.enumCodec(LookDirection.class), ActivatorSettings::lookDirection, (StreamCodec)NeoForgeStreamCodecs.enumCodec(EntityMode.class), ActivatorSettings::entityMode, (StreamCodec)ByteBufCodecs.BOOL, ActivatorSettings::sneaking, ActivatorSettings::new);
    }

    public static enum ActionType implements TranslatableEnum,
    StringRepresentable
    {
        ITEM_OR_BLOCK("item_or_block", false),
        USE_ITEM_ON_ENTITY("use_item_on_entity", true),
        ATTACK_ENTITY("attack_entity", true);

        private final boolean entity;
        private final String name;

        private ActionType(String name, boolean entity) {
            this.entity = entity;
            this.name = name;
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.itemText.activator.action." + this.name;
        }

        public boolean isEntityTarget() {
            return this.entity;
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    public static enum LookDirection implements TranslatableEnum,
    StringRepresentable
    {
        LEVEL("level", 0.0f),
        ABOVE("above", -45.0f),
        BELOW("below", 45.0f);

        private final String name;
        private final float pitch;

        private LookDirection(String name, float pitch) {
            this.name = name;
            this.pitch = pitch;
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.itemText.activator.direction." + this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    public static enum EntityMode implements TranslatableEnum,
    StringRepresentable
    {
        NEAREST("nearest"),
        RANDOM("random"),
        ROUND_ROBIN("round_robin");

        private final String name;

        private EntityMode(String name) {
            this.name = name;
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.itemText.activator.entityMode." + this.getSerializedName();
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

