/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.integration.jade;

import java.util.HashMap;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;

public class RouterDataProvider
implements IServerDataProvider<BlockAccessor> {
    public void appendServerData(CompoundTag compoundTag, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof ModularRouterBlockEntity) {
            ModularRouterBlockEntity router = (ModularRouterBlockEntity)blockEntity;
            if (router.isPermitted(accessor.getPlayer())) {
                compoundTag.putInt("ModuleCount", router.getModuleCount());
                compoundTag.putInt("RedstoneMode", router.getRedstoneBehaviour().ordinal());
                compoundTag.putBoolean("EcoMode", router.getEcoMode());
                compoundTag.put("Upgrades", (Tag)this.getUpgrades(router));
            } else {
                compoundTag.putBoolean("Denied", true);
            }
        }
    }

    private CompoundTag getUpgrades(ModularRouterBlockEntity router) {
        IItemHandler handler = router.getUpgrades();
        HashMap<Item, Integer> counts = new HashMap<Item, Integer>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!(stack.getItem() instanceof UpgradeItem)) continue;
            counts.put(stack.getItem(), counts.getOrDefault(stack.getItem(), 0) + stack.getCount());
        }
        return (CompoundTag)Util.make((Object)new CompoundTag(), tag -> counts.forEach((k, v) -> tag.putInt(k.getDescriptionId(), v.intValue())));
    }

    public ResourceLocation getUid() {
        return MiscUtil.RL("router");
    }
}

