/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.core;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import me.desht.modularrouters.recipe.GuideBookRecipe;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class ModCreativeModeTabs {
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"modularrouters");
    public static final Supplier<CreativeModeTab> DEFAULT = TABS.register("default", ModCreativeModeTabs::buildDefaultTab);

    private static CreativeModeTab buildDefaultTab() {
        return CreativeModeTab.builder().title((Component)Component.literal((String)"Modular Routers")).icon(() -> new ItemStack((ItemLike)ModBlocks.MODULAR_ROUTER.get())).displayItems((params, output) -> output.acceptAll(ModCreativeModeTabs.collectItems())).build();
    }

    @NotNull
    private static List<ItemStack> collectItems() {
        List items = ModItems.ITEMS.getEntries().stream().map(ro -> new ItemStack((ItemLike)ro.get())).sorted(new ItemSorter()).collect(Collectors.toCollection(ArrayList::new));
        if (ModList.get().isLoaded("patchouli")) {
            items.add(GuideBookRecipe.makeGuideBook());
        }
        return items;
    }

    private static class ItemSorter
    implements Comparator<ItemStack> {
        private ItemSorter() {
        }

        @Override
        public int compare(ItemStack s1, ItemStack s2) {
            for (Class<SmartFilterItem> cls : List.of(BlockItem.class, ModuleItem.class, UpgradeItem.class, AugmentItem.class, SmartFilterItem.class)) {
                if (cls.isAssignableFrom(s1.getItem().getClass()) && !cls.isAssignableFrom(s2.getItem().getClass())) {
                    return -1;
                }
                if (!cls.isAssignableFrom(s2.getItem().getClass()) || cls.isAssignableFrom(s1.getItem().getClass())) continue;
                return 1;
            }
            return s1.getDisplayName().getString().compareTo(s2.getDisplayName().getString());
        }
    }
}

