/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container.handler;

import java.util.IdentityHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.core.ModBlocks;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class BufferHandler
extends ItemStackHandler {
    private static final Object NULL = new Object();
    private final ModularRouterBlockEntity router;
    private final IdentityHashMap<ItemCapability<?, Void>, Object> capabilityCache = new IdentityHashMap(4);

    public BufferHandler(ModularRouterBlockEntity router) {
        super(router.getBufferSlotCount());
        this.router = router;
    }

    public void onContentsChanged(int slot) {
        if (!this.capabilityCache.isEmpty()) {
            ItemStack stack = this.getStackInSlot(slot);
            AtomicBoolean modified = new AtomicBoolean();
            this.capabilityCache.replaceAll((cap, old) -> this.revalidate(stack, (ItemCapability)cap, (Object)old, modified));
            if (modified.get()) {
                this.router.invalidateCapabilities();
                this.router.nonNullLevel().updateNeighborsAt(this.router.getBlockPos(), (Block)ModBlocks.MODULAR_ROUTER.get());
            }
        }
        this.router.setChanged();
    }

    private <T> T revalidate(ItemStack stack, ItemCapability<T, Void> cap, T old, AtomicBoolean modified) {
        Object newVal = BufferHandler.maskNull(stack.getCapability(cap));
        if (newVal != old) {
            modified.compareAndSet(false, true);
        }
        return (T)newVal;
    }

    public IFluidHandlerItem getFluidHandler() {
        return (IFluidHandlerItem)this.getCapability(Capabilities.FluidHandler.ITEM);
    }

    public IEnergyStorage getEnergyStorage() {
        return (IEnergyStorage)this.getCapability(Capabilities.EnergyStorage.ITEM);
    }

    @Nullable
    public <T> T getCapability(ItemCapability<T, Void> cap) {
        Object cached = this.capabilityCache.get(cap);
        if (cached == null) {
            cached = BufferHandler.maskNull(this.getStackInSlot(0).getCapability(cap));
            this.capabilityCache.put(cap, cached);
        }
        return (T)(cached == NULL ? null : cached);
    }

    private static <T> T maskNull(T value) {
        return (T)(value == null ? NULL : value);
    }
}

