/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.widgets.button;

import me.desht.modularrouters.client.gui.ISendToServer;
import me.desht.modularrouters.client.gui.widgets.button.TexturedButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.util.TranslatableEnum;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class TexturedCyclerButton<T extends Enum<T>>
extends TexturedButton {
    private T state;
    private final int len;

    public TexturedCyclerButton(int x, int y, int width, int height, T initialVal, ISendToServer dataSyncer) {
        super(x, y, width, height, button -> {
            ((TexturedCyclerButton)button).cycle(!Screen.hasShiftDown());
            dataSyncer.sendToServer();
        });
        this.setState(initialVal);
        this.len = ((Enum[])initialVal.getClass().getEnumConstants()).length;
    }

    public T getState() {
        return this.state;
    }

    public void setState(T newState) {
        this.state = newState;
        this.setTooltip(((TranslatableEnum)this.state).getTranslationKey() == null ? null : this.makeTooltip(this.state));
    }

    protected Tooltip makeTooltip(T object) {
        return Tooltip.create((Component)ClientUtil.xlate(((TranslatableEnum)object).getTranslationKey(), new Object[0]));
    }

    public void cycle(boolean forward) {
        int b = ((Enum)this.state).ordinal();
        if ((b += forward ? 1 : -1) >= this.len) {
            b = 0;
        } else if (b < 0) {
            b = this.len - 1;
        }
        this.setState(((Enum[])this.state.getClass().getEnumConstants())[b]);
    }
}

