/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.loot;

import com.buuz135.sushigocrafting.item.AmountItem;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class ItemAmountLootModifier
extends LootModifier {
    public static final MapCodec<ItemAmountLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> ItemAmountLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, ItemAmountLootModifier::new));

    public ItemAmountLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ObjectArrayList customLoot = new ObjectArrayList();
        for (ItemStack stack : generatedLoot) {
            if (stack.getItem() instanceof AmountItem) {
                customLoot.add((Object)((AmountItem)stack.getItem()).random(null, (Level)context.getLevel()));
                continue;
            }
            customLoot.add((Object)stack);
        }
        return customLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

