/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.datagen;

import com.buuz135.sushigocrafting.block.plant.CustomCropBlock;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class SushiLootTableProvider
extends LootTableProvider {
    public SushiLootTableProvider(DataGenerator gen, CompletableFuture<HolderLookup.Provider> registries) {
        super(gen.getPackOutput(), new HashSet(), new ArrayList(), registries);
    }

    public List<LootTableProvider.SubProviderEntry> getTables() {
        return Arrays.asList(new LootTableProvider.SubProviderEntry(SushiBlockLootTables::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(x$0 -> new SushiEntityLootTables(this, (HolderLookup.Provider)x$0), LootContextParamSets.ENTITY));
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
    }

    private class SushiEntityLootTables
    extends EntityLootSubProvider {
        protected SushiEntityLootTables(SushiLootTableProvider sushiLootTableProvider, HolderLookup.Provider registries) {
            super(FeatureFlags.REGISTRY.allFlags(), registries);
        }

        public void generate() {
            this.add((EntityType)SushiContent.EntityTypes.TUNA.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)SushiContent.Items.RAW_TUNA.get())))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE_MEAL)).when(LootItemRandomChanceCondition.randomChance((float)0.05f))));
            this.add((EntityType)SushiContent.EntityTypes.SHRIMP.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)SushiContent.Items.SHRIMP.get())))));
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return Arrays.asList((EntityType)SushiContent.EntityTypes.TUNA.get(), (EntityType)SushiContent.EntityTypes.SHRIMP.get()).stream();
        }
    }

    private static class SushiBlockLootTables
    extends BlockLootSubProvider {
        private final List<Block> knownBlocks = new ArrayList<Block>();

        protected SushiBlockLootTables(HolderLookup.Provider registries) {
            super(new HashSet(), FeatureFlags.REGISTRY.allFlags(), registries);
        }

        protected void generate() {
            this.crop((Supplier<CustomCropBlock>)SushiContent.Blocks.RICE_CROP, (Supplier<? extends Item>)SushiContent.Items.RICE);
            this.crop((Supplier<CustomCropBlock>)SushiContent.Blocks.CUCUMBER_CROP, (Supplier<? extends Item>)SushiContent.Items.CUCUMBER);
            this.crop((Supplier<CustomCropBlock>)SushiContent.Blocks.SOY_CROP, (Supplier<? extends Item>)SushiContent.Items.SOY_BEAN);
            this.crop((Supplier<CustomCropBlock>)SushiContent.Blocks.WASABI_CROP, (Supplier<? extends Item>)SushiContent.Items.WASABI_ROOT);
            this.crop((Supplier<CustomCropBlock>)SushiContent.Blocks.SESAME_CROP, (Supplier<? extends Item>)SushiContent.Items.SESAME_SEED);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.AVOCADO_SAPLING);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.RICE_COOKER);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.CUTTING_BOARD);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.AVOCADO_LOG);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.ROLLER);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.FERMENTATION_BARREL);
            this.dropLeaves((Supplier<Block>)SushiContent.Blocks.AVOCADO_LEAVES, (Supplier<Block>)SushiContent.Blocks.AVOCADO_SAPLING);
            this.dropLeavesSpecial((Supplier<? extends Block>)SushiContent.Blocks.AVOCADO_LEAVES_LOG, (Supplier<? extends Block>)SushiContent.Blocks.AVOCADO_LOG);
            this.add((Block)SushiContent.Blocks.COOLER_BOX.get(), SushiBlockLootTables.noDrop());
            this.knownBlocks.add((Block)SushiContent.Blocks.COOLER_BOX.get());
        }

        private void crop(Supplier<CustomCropBlock> blockSupplier, Supplier<? extends Item> extra) {
            LootItemBlockStatePropertyCondition.Builder condition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)blockSupplier.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)blockSupplier.get().getAgeProperty(), blockSupplier.get().getMaxAge()));
            this.add((Block)blockSupplier.get(), this.createCropDrops((Block)blockSupplier.get(), extra.get(), blockSupplier.get().getBaseSeedId().asItem(), (LootItemCondition.Builder)condition));
            this.knownBlocks.add((Block)blockSupplier.get());
        }

        private void dropSelf(Supplier<? extends Block> blockSupplier) {
            this.dropSelf(blockSupplier.get());
            this.knownBlocks.add(blockSupplier.get());
        }

        private void dropOther(Supplier<Block> blockSupplier, Supplier<? extends ItemLike> other) {
            this.dropOther(blockSupplier.get(), other.get());
            this.knownBlocks.add(blockSupplier.get());
        }

        private void dropLeaves(Supplier<Block> blockSupplier, Supplier<Block> sapling) {
            this.add(blockSupplier.get(), leaves -> this.createLeavesDrops((Block)leaves, (Block)sapling.get(), new float[]{0.2f, 0.25f, 0.35f, 0.45f}));
            this.knownBlocks.add(blockSupplier.get());
        }

        private void dropLeavesSpecial(Supplier<? extends Block> blockSupplier, Supplier<? extends Block> extra) {
            this.add(blockSupplier.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)extra.get())))));
            this.knownBlocks.add(blockSupplier.get());
        }

        public void droppingSelfWithNbt(Supplier<? extends Block> itemProvider, CopyComponentsFunction.Builder nbtBuilder) {
            this.add(itemProvider.get(), LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)itemProvider.get(), (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)itemProvider.get())).apply((LootItemFunction.Builder)nbtBuilder)))));
            this.knownBlocks.add(itemProvider.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.knownBlocks;
        }
    }
}

