/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.compat.jei;

import com.buuz135.sushigocrafting.api.impl.FoodHelper;
import com.buuz135.sushigocrafting.compat.jei.categories.CuttingBoardCategory;
import com.buuz135.sushigocrafting.compat.jei.categories.FermentationBarrelCategory;
import com.buuz135.sushigocrafting.compat.jei.categories.RiceCookerCategory;
import com.buuz135.sushigocrafting.compat.jei.categories.RollerCategory;
import com.buuz135.sushigocrafting.compat.jei.categories.SushiRecipeTypes;
import com.buuz135.sushigocrafting.item.FoodItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.neoforged.neoforge.registries.DeferredHolder;

@JeiPlugin
public class JEIModPlugin
implements IModPlugin {
    public static List<ItemStack> FUELS;
    private CuttingBoardCategory cuttingBoardRecipe;
    private RollerCategory rollerCategory;
    private RiceCookerCategory riceCookerCategory;
    private FermentationBarrelCategory fermentationBarrelCategory;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        this.cuttingBoardRecipe = new CuttingBoardCategory(registry.getJeiHelpers().getGuiHelper());
        iRecipeCategoryArray[0] = this.cuttingBoardRecipe;
        registry.addRecipeCategories(iRecipeCategoryArray);
        IRecipeCategory[] iRecipeCategoryArray2 = new IRecipeCategory[1];
        this.rollerCategory = new RollerCategory(registry.getJeiHelpers().getGuiHelper());
        iRecipeCategoryArray2[0] = this.rollerCategory;
        registry.addRecipeCategories(iRecipeCategoryArray2);
        IRecipeCategory[] iRecipeCategoryArray3 = new IRecipeCategory[1];
        this.riceCookerCategory = new RiceCookerCategory(registry.getJeiHelpers().getGuiHelper());
        iRecipeCategoryArray3[0] = this.riceCookerCategory;
        registry.addRecipeCategories(iRecipeCategoryArray3);
        IRecipeCategory[] iRecipeCategoryArray4 = new IRecipeCategory[1];
        this.fermentationBarrelCategory = new FermentationBarrelCategory(registry.getJeiHelpers().getGuiHelper());
        iRecipeCategoryArray4[0] = this.fermentationBarrelCategory;
        registry.addRecipeCategories(iRecipeCategoryArray4);
        FUELS = BuiltInRegistries.ITEM.stream().filter(item -> FurnaceBlockEntity.isFuel((ItemStack)new ItemStack((ItemLike)item))).map(ItemStack::new).collect(Collectors.toList());
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(SushiRecipeTypes.RICE_COOKER, List.of(new RiceCookerCategory.RiceCookerRecipe()));
        registration.addRecipes(SushiRecipeTypes.CUTTING_BOARD, RecipeUtil.getRecipes((Level)Minecraft.getInstance().level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)SushiContent.RecipeTypes.CUTTING_BOARD.get())));
        registration.addRecipes(SushiRecipeTypes.ROLLER, FoodHelper.REGISTERED.values().stream().flatMap(Collection::stream).map(DeferredHolder::get).map(item -> (FoodItem)((Object)item)).map(RollerCategory.Recipe::new).collect(Collectors.toList()));
        registration.addRecipes(SushiRecipeTypes.FERMENTING_BARREL, RecipeUtil.getRecipes((Level)Minecraft.getInstance().level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)SushiContent.RecipeTypes.FERMENTING_BARREL.get())));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)SushiContent.Blocks.CUTTING_BOARD.get()), new RecipeType[]{SushiRecipeTypes.CUTTING_BOARD});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)SushiContent.Blocks.ROLLER.get()), new RecipeType[]{SushiRecipeTypes.ROLLER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)SushiContent.Blocks.RICE_COOKER.get()), new RecipeType[]{SushiRecipeTypes.RICE_COOKER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)SushiContent.Blocks.FERMENTATION_BARREL.get()), new RecipeType[]{SushiRecipeTypes.FERMENTING_BARREL});
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"sushigocrafting", (String)"default");
    }
}

