/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.FramedBlock;
import com.buuz135.functionalstorage.block.FramedDrawerBlock;
import com.buuz135.functionalstorage.block.tile.FramedTile;
import com.buuz135.functionalstorage.client.model.FramedDrawerModelData;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="functionalstorage", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class FramedColors
implements BlockColor,
ItemColor {
    public int getColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        FramedTile tile;
        FramedDrawerModelData framedDrawerModelData;
        BlockEntity blockEntity;
        if (level != null && pos != null && tintIndex == 0 && (blockEntity = level.getBlockEntity(pos)) instanceof FramedTile && (framedDrawerModelData = (tile = (FramedTile)blockEntity).getFramedDrawerModelData()) != null) {
            for (Map.Entry<String, Item> entry : framedDrawerModelData.getDesign().entrySet()) {
                BlockItem blockItem;
                Item item = entry.getValue();
                if (!(item instanceof BlockItem) || BuiltInRegistries.ITEM.getKey((Object)(blockItem = (BlockItem)item)).getNamespace().equals("functionalstorage")) continue;
                BlockState state1 = blockItem.getBlock().defaultBlockState();
                int color = Minecraft.getInstance().getBlockColors().getColor(state1, level, pos, tintIndex);
                if (color == -1) continue;
                return color;
            }
        }
        return 0xFFFFFF;
    }

    public int getColor(ItemStack itemStack, int tintIndex) {
        FramedDrawerModelData framedDrawerModelData;
        BlockItem item;
        Item item2;
        if (tintIndex == 0 && (item2 = itemStack.getItem()) instanceof BlockItem && (item = (BlockItem)item2).getBlock() instanceof FramedBlock && (framedDrawerModelData = FramedDrawerBlock.getDrawerModelData(itemStack)) != null) {
            for (Map.Entry<String, Item> entry : framedDrawerModelData.getDesign().entrySet()) {
                int color;
                if (!(entry.getValue() instanceof BlockItem) || (color = Minecraft.getInstance().getItemColors().getColor(itemStack, tintIndex)) == -1) continue;
                return color;
            }
        }
        return 0xFFFFFF;
    }

    @SubscribeEvent
    static void blockColors(RegisterColorHandlersEvent.Block event) {
        FramedColors instance = new FramedColors();
        FunctionalStorage.FRAMED_BLOCKS.forEach(bl -> event.register((BlockColor)instance, new Block[]{bl}));
    }

    @SubscribeEvent
    static void itemColors(RegisterColorHandlersEvent.Item event) {
        FramedColors instance = new FramedColors();
        FunctionalStorage.FRAMED_BLOCKS.forEach(bl -> event.register((ItemColor)instance, new ItemLike[]{bl}));
    }
}

