/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import mob_grinding_utils.MobGrindingUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record SolidifyRecipe(Ingredient mould, ItemStack result, int fluidAmount) implements Recipe<RecipeInput>
{
    private final ItemStack result;
    public static final String NAME = "solidify";

    public boolean matches(@Nonnull RecipeInput inv, @Nonnull Level worldIn) {
        return false;
    }

    public boolean matches(ItemStack input) {
        return this.mould.test(input);
    }

    @Nonnull
    public ItemStack assemble(@Nonnull RecipeInput inv, @Nonnull HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public ItemStack result() {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider registries) {
        return this.result;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MobGrindingUtils.SOLIDIFIER_RECIPE.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)MobGrindingUtils.SOLIDIFIER_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<SolidifyRecipe> {
        public static final MapCodec<SolidifyRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.mould), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("fluidAmount").forGetter(recipe -> recipe.fluidAmount)).apply((Applicative)instance, SolidifyRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SolidifyRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Nonnull
        public MapCodec<SolidifyRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SolidifyRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        @Nonnull
        public static SolidifyRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            Ingredient mould = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int fluidAmount = buffer.readInt();
            return new SolidifyRecipe(mould, result, fluidAmount);
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, SolidifyRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.mould);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeInt(recipe.fluidAmount);
        }
    }
}

