/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.recipe;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.components.MGUComponents;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class ChickenFeedRecipe
extends ShapelessRecipe {
    public static final String NAME = "chicken_feed";

    public ChickenFeedRecipe(ShapelessRecipe recipe) {
        super(recipe.getGroup(), recipe.category(), recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY), recipe.getIngredients());
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInput inv, @Nonnull HolderLookup.Provider lol) {
        ItemStack result = super.assemble(inv, lol);
        ItemStack swabItem = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || stack.getItem() != ModItems.MOB_SWAB_USED.get()) continue;
            swabItem = stack;
        }
        if (!swabItem.has(MGUComponents.MOB_DNA)) {
            return ItemStack.EMPTY;
        }
        result.set(MGUComponents.MOB_DNA, (Object)((ResourceLocation)swabItem.get(MGUComponents.MOB_DNA)));
        return result;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MobGrindingUtils.CHICKEN_FEED.get();
    }

    public static class Serializer
    implements RecipeSerializer<ChickenFeedRecipe> {
        public static final MapCodec<ChickenFeedRecipe> CODEC = ShapelessRecipe.Serializer.CODEC.xmap(ChickenFeedRecipe::new, recipe -> recipe);
        public static final StreamCodec<RegistryFriendlyByteBuf, ChickenFeedRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Nonnull
        public MapCodec<ChickenFeedRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ChickenFeedRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static ChickenFeedRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            return new ChickenFeedRecipe((ShapelessRecipe)RecipeSerializer.SHAPELESS_RECIPE.streamCodec().decode((Object)buffer));
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, @Nonnull ChickenFeedRecipe recipe) {
            try {
                RecipeSerializer.SHAPELESS_RECIPE.streamCodec().encode((Object)buffer, (Object)recipe);
            }
            catch (Exception exception) {
                MobGrindingUtils.LOGGER.info("Error writing chicken_feed Recipe to packet: ", (Throwable)exception);
                throw exception;
            }
        }
    }
}

