/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.itemblocks;

import java.util.List;
import javax.annotation.Nonnull;
import mob_grinding_utils.blocks.BlockTank;
import mob_grinding_utils.components.FluidContents;
import mob_grinding_utils.components.MGUComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;

public class BlockItemTank
extends BlockItem {
    private final int capacity;

    public BlockItemTank(BlockTank blockIn, int capacity, Item.Properties builder) {
        super((Block)blockIn, builder);
        this.capacity = capacity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        if (stack.has(MGUComponents.FLUID)) {
            FluidStack fluid = ((FluidContents)stack.getOrDefault(MGUComponents.FLUID, (Object)FluidContents.EMPTY)).get();
            if (!fluid.isEmpty()) {
                list.add((Component)Component.literal((String)("Contains: " + fluid.getHoverName().getString())).withStyle(ChatFormatting.GREEN));
                list.add((Component)Component.literal((String)String.format("%dMb/%dMb", fluid.getAmount(), this.capacity)).withStyle(ChatFormatting.BLUE));
            }
        } else {
            list.add((Component)Component.literal((String)String.format("Holds %dMb (%d Buckets)", this.capacity, this.capacity / 1000)).withStyle(ChatFormatting.BLUE));
        }
    }
}

