/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CandleHolderBlock;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BuzzierBeesCompat {
    public static final List<Supplier<? extends Block>> BB_CANDLES = new ArrayList<Supplier<? extends Block>>();

    public static void registerCandle(ResourceLocation id, Function<BlockState, List<Vec3>> particleOffsets) {
        BuzzierBeesCompat.registerCandle(id, "_soul", CompatObjects.SMALL_SOUL_FLAME, particleOffsets);
        if (CompatHandler.ENDERGETIC) {
            BuzzierBeesCompat.registerCandle(id, "_ender", CompatObjects.SMALL_END_FLAME, particleOffsets);
        }
        if (CompatHandler.CAVERNS_AND_CHASMS) {
            BuzzierBeesCompat.registerCandle(id, "_cupric", CompatObjects.SMALL_CUPRIC_FLAME, particleOffsets);
        }
    }

    private static void registerCandle(ResourceLocation id, String _end, Supplier<ParticleType<?>> flame, Function<BlockState, List<Vec3>> offsets) {
        String name = id.getPath() + _end;
        RegSupplier b = RegHelper.registerBlockWithItem((ResourceLocation)id.withPath(name), () -> new CandleHolderBlock(null, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)ModRegistry.SCONCE.get())), flame, offsets));
        BB_CANDLES.add((Supplier<? extends Block>)b);
        ModRegistry.ALL_CANDLE_HOLDERS.add((Supplier<? extends Block>)b);
    }

    public static void setupClient() {
        BB_CANDLES.forEach(b -> ClientHelper.registerRenderType((Block)((Block)b.get()), (RenderType)RenderType.cutout()));
    }
}

