/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.entity.ParticleTrailEmitter;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.TntBehavior;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.items.BombItem;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModDamageSources;
import net.mehvahdjukaar.supplementaries.reg.ModEnchantments;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SlingshotProjectileEntity
extends ImprovedProjectileEntity
implements IExtraClientSpawnData {
    private static final EntityDataAccessor<Byte> LOYALTY = SynchedEntityData.defineId(SlingshotProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected int MAX_AGE = 700;
    private float xRotInc;
    private float yRotInc;
    private float particleCooldown = 0.0f;
    private final ParticleTrailEmitter trailEmitter = ParticleTrailEmitter.builder().spacing(3.0).maxParticlesPerTick(5).build();
    private final Supplier<Integer> light = Suppliers.memoize(() -> {
        Item item = this.getItem().getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block b = blockItem.getBlock();
            return b.defaultBlockState().getLightEmission();
        }
        return 0;
    });

    public SlingshotProjectileEntity(Level world, ItemStack item, ItemStack throwerStack, @Nullable LivingEntity thrower) {
        this(world, item, throwerStack);
        if (thrower != null) {
            this.setPos(thrower.getX(), thrower.getEyeY() - 0.1, thrower.getZ());
            this.setOwner((Entity)thrower);
        }
    }

    public SlingshotProjectileEntity(Level world, ItemStack item, ItemStack throwerStack) {
        super(ModEntities.SLINGSHOT_PROJECTILE.get(), world);
        this.maxAge = this.MAX_AGE;
        this.setItem(item);
        this.setLoyalty(this.getLoyaltyFromItem(item));
        this.setNoGravity(EnchantmentHelper.has((ItemStack)throwerStack, ModEnchantments.PROJECTILE_NO_GRAVITY.get()));
        this.yRotInc = (float)(this.random.nextBoolean() ? 1 : -1) * (float)(4.0 * this.random.nextGaussian() + 7.0);
        this.xRotInc = (float)(this.random.nextBoolean() ? 1 : -1) * (float)(4.0 * this.random.nextGaussian() + 7.0);
        this.setXRot(this.random.nextFloat() * 360.0f);
        this.setYRot(this.random.nextFloat() * 360.0f);
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.maxStuckTime = 0;
    }

    public SlingshotProjectileEntity(EntityType<SlingshotProjectileEntity> type, Level world) {
        super(type, world);
        this.maxAge = this.MAX_AGE;
        this.maxStuckTime = 0;
    }

    private byte getLoyaltyFromItem(ItemStack itemStack) {
        byte by;
        Level var3 = this.level();
        if (var3 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)var3;
            by = (byte)Mth.clamp((int)EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)serverLevel, (ItemStack)itemStack, (Entity)this), (int)0, (int)127);
        } else {
            by = 0;
        }
        return by;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return PlatHelper.getEntitySpawnPacket((Entity)this, (ServerEntity)serverEntity);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LOYALTY, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setLoyalty(tag.getByte("Loyalty"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte("Loyalty", this.getLoyalty());
    }

    private void setLoyalty(byte loyalty) {
        this.entityData.set(LOYALTY, (Object)loyalty);
    }

    public byte getLoyalty() {
        return (Byte)this.entityData.get(LOYALTY);
    }

    protected Item getDefaultItem() {
        return Items.STONE;
    }

    protected void onHitEntity(EntityHitResult entityRayTraceResult) {
        Entity entity;
        super.onHitEntity(entityRayTraceResult);
        ItemStack stack = this.getItem();
        if (!this.tryDeployingProjectiles() && (entity = entityRayTraceResult.getEntity()) instanceof EnderMan) {
            BlockItem bi;
            Block block;
            EnderMan enderman = (EnderMan)entity;
            Item item = stack.getItem();
            if (item instanceof BlockItem && ((block = (bi = (BlockItem)item).getBlock()).builtInRegistryHolder().is(BlockTags.ENDERMAN_HOLDABLE) || CommonConfigs.Tools.UNRESTRICTED_SLINGSHOT.get().booleanValue()) && enderman.getCarriedBlock() == null) {
                enderman.setCarriedBlock(block.defaultBlockState());
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
        if (stack.is(ModTags.SLINGSHOT_DAMAGEABLE)) {
            float speed = (float)this.getDeltaMovement().length();
            double baseDamage = CommonConfigs.Tools.SLINGSHOT_DAMAGEABLE_DAMAGE.get();
            int damage = Mth.ceil((double)Mth.clamp((double)((double)speed * baseDamage), (double)0.0, (double)2.147483647E9));
            entityRayTraceResult.getEntity().hurt(ModDamageSources.slingshot(this.level(), (Entity)this, this.getOwner()), (float)damage);
            this.kill();
        }
    }

    protected void onHitBlock(BlockHitResult hit) {
        Player p;
        super.onHitBlock(hit);
        Level level = this.level();
        ItemStack stack = this.getItem();
        Item item = stack.getItem();
        Entity entity = this.getOwner();
        Player player = entity instanceof Player ? (p = (Player)entity) : FakePlayerManager.getDefault((Entity)this, (Entity)this);
        boolean success = this.tryDeployingProjectiles();
        if (!success && item instanceof DispensibleContainerItem) {
            DispensibleContainerItem dc = (DispensibleContainerItem)item;
            if (item.hasCraftingRemainingItem()) {
                Item craftingRemainingItem = stack.getItem().getCraftingRemainingItem();
                SuppPlatformStuff.dispenseContent(dc, stack, hit, level, player);
                dc.checkExtraContent(player, level, stack, hit.getBlockPos());
                if (craftingRemainingItem != null) {
                    this.setItem(craftingRemainingItem.getDefaultInstance());
                } else {
                    success = true;
                }
            }
        }
        if (!success) {
            BlockPlaceContext context = new BlockPlaceContext(level, player, InteractionHand.MAIN_HAND, stack, hit);
            success = ItemsUtil.place(item, context).consumesAction();
            if (success && CommonConfigs.Functional.CANNON_EXPLODE_TNT.get() == CommonConfigs.TNTMode.IGNITE_ON_IMPACT && level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                BlockPos pos = context.getClickedPos();
                BlockState placed = level.getBlockState(pos);
                TntBehavior.igniteTntHack(placed, (Level)sl, pos);
                level.removeBlock(pos, false);
            }
            this.isStuck = true;
        }
        if (success) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    private boolean tryDeployingProjectiles() {
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            Object ent = null;
            Item item = this.getItem().getItem();
            Level level = this.level();
            if (item instanceof ThrowablePotionItem) {
                ThrownPotion p = new ThrownPotion(level, le);
                p.setPos(this.getX(), this.getY(), this.getZ());
                p.setItem(this.getItem());
                ent = p;
            } else if (item == Items.FIRE_CHARGE) {
                SmallFireball p = new SmallFireball(level, le, Vec3.ZERO);
                p.setPos(this.getX(), this.getY(), this.getZ());
                p.setItem(this.getItem());
                ent = p;
            } else if (item instanceof SnowballItem) {
                Snowball s = new Snowball(level, le);
                s.setPos(this.getX(), this.getY(), this.getZ());
                s.setItem(this.getItem());
                ent = s;
            } else if (item instanceof BombItem) {
                BombItem bi = (BombItem)item;
                BombEntity s = new BombEntity(level, le, bi.getType());
                s.setPos(this.getX(), this.getY(), this.getZ());
                s.setItem(this.getItem());
                ent = s;
            } else if (item instanceof EnderpearlItem) {
                ThrownEnderpearl s = new ThrownEnderpearl(level, le);
                s.setPos(this.getX(), this.getY(), this.getZ());
                s.setItem(this.getItem());
                ent = s;
            }
            if (ent != null) {
                level.addFreshEntity(ent);
                ent.tick();
                return true;
            }
        }
        return false;
    }

    public void tick() {
        if (this.isNoPhysics()) {
            byte loyaltyLevel = this.getLoyalty();
            Entity owner = this.getOwner();
            if (loyaltyLevel > 0 && this.isAcceptableReturnOwner(owner)) {
                Vec3 force = new Vec3(owner.getX() - this.getX(), owner.getEyeY() - this.getY(), owner.getZ() - this.getZ());
                this.setPosRaw(this.getX(), this.getY() + force.y * 0.015 * (double)loyaltyLevel, this.getZ());
                if (this.level().isClientSide) {
                    this.yOld = this.getY();
                }
                double d0 = 0.05 * (double)loyaltyLevel;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(force.normalize().scale(d0)));
            }
        }
        super.tick();
    }

    private boolean isAcceptableReturnOwner(Entity owner) {
        if (owner != null && owner.isAlive()) {
            return !(owner instanceof ServerPlayer) || !owner.isSpectator();
        }
        return false;
    }

    public void playerTouch(Player playerEntity) {
        if (!this.level().isClientSide && this.hasLeftOwner() && (this.isNoPhysics() || this.isStuck)) {
            boolean success = playerEntity.getAbilities().instabuild || playerEntity.getInventory().add(this.getItem());
            Level level = this.level();
            if (!success) {
                this.spawnAtLocation(this.getItem(), 0.1f);
            } else {
                level.playSound(null, (Entity)playerEntity, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (this.random.nextFloat() - this.random.nextFloat()) * 1.4f + 2.0f);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean hasReachedEndOfLife() {
        if (this.isNoGravity() && this.getDeltaMovement().lengthSqr() < 0.005) {
            return true;
        }
        return super.hasReachedEndOfLife();
    }

    public void reachedEndOfLife() {
        if (this.getLoyalty() != 0 && this.isAcceptableReturnOwner(this.getOwner())) {
            this.setNoPhysics(true);
            this.stuckTime = 0;
        } else {
            this.spawnAtLocation(this.getItem(), 0.1f);
            super.reachedEndOfLife();
        }
    }

    protected void updateRotation() {
        if (!this.isNoGravity()) {
            this.xRotO = this.getXRot();
            this.yRotO = this.getYRot();
            this.setXRot(this.getXRot() + this.xRotInc);
            this.setYRot(this.getYRot() + this.yRotInc);
            this.particleCooldown += 1.0f;
        } else {
            super.updateRotation();
        }
    }

    public void spawnTrailParticles() {
        super.spawnTrailParticles();
        if (!this.isNoPhysics()) {
            double speed = this.getDeltaMovement().length();
            if (this.tickCount > 1 && speed * (double)this.tickCount > 1.5) {
                if (this.isNoGravity()) {
                    Vec3 rot = new Vec3(0.325, 0.0, 0.0).yRot((float)this.tickCount * 0.32f);
                    Vec3 movement = this.getDeltaMovement();
                    Vec3 offset = MthUtils.changeBasisN((Vec3)movement, (Vec3)rot);
                    double px = this.getX() + offset.x;
                    double py = this.getEyeY() + offset.y;
                    double pz = this.getZ() + offset.z;
                    movement = movement.scale(0.25);
                    this.level().addParticle((ParticleOptions)ModParticles.STASIS_PARTICLE.get(), px, py, pz, movement.x, movement.y, movement.z);
                } else {
                    this.trailEmitter.tick((Entity)this, (p, v) -> this.level().addParticle((ParticleOptions)ModParticles.SLINGSHOT_PARTICLE.get(), p.x, p.y, p.z, 0.0, 0.01, 0.0));
                }
            }
        }
    }

    protected float getInertia() {
        return this.isNoGravity() ? (float)CommonConfigs.Tools.SLINGSHOT_DECELERATION.get().doubleValue() : super.getInertia();
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        Entity entity = this.getOwner();
        int id = -1;
        if (entity != null) {
            id = entity.getId();
        }
        buffer.writeInt(id);
        buffer.writeFloat(this.xRotInc);
        buffer.writeFloat(this.yRotInc);
        buffer.writeFloat(this.getXRot());
        buffer.writeFloat(this.getYRot());
    }

    public void readSpawnData(RegistryFriendlyByteBuf buffer) {
        int id = buffer.readInt();
        if (id != -1) {
            this.setOwner(this.level().getEntity(id));
        }
        this.xRotInc = buffer.readFloat();
        this.yRotInc = buffer.readFloat();
        this.setXRot(buffer.readFloat());
        this.setYRot(buffer.readFloat());
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
    }

    public int getLightEmission() {
        return this.light.get();
    }
}

