/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.GameRules;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class HUDOverlays {
    public static int healthIconsOffset;
    public static int foodIconsOffset;
    private static final ResourceLocation MOD_ICONS_TEXTURE;

    public static void register(RegisterGuiLayersEvent event) {
        event.registerBelow(VanillaGuiLayers.PLAYER_HEALTH, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"health_offset"), (guiGraphics, deltaTracker) -> {
            healthIconsOffset = Minecraft.getInstance().gui.leftHeight;
        });
        event.registerBelow(VanillaGuiLayers.FOOD_LEVEL, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"food_offset"), (guiGraphics, deltaTracker) -> {
            foodIconsOffset = Minecraft.getInstance().gui.rightHeight;
        });
        event.registerAbove(VanillaGuiLayers.PLAYER_HEALTH, ComfortOverlay.ID, (LayeredDraw.Layer)new ComfortOverlay());
        event.registerAbove(VanillaGuiLayers.FOOD_LEVEL, NourishmentOverlay.ID, (LayeredDraw.Layer)new NourishmentOverlay());
    }

    public static void drawNourishmentOverlay(FoodData foodData, Minecraft minecraft, GuiGraphics graphics, int right, int top, boolean naturalHealing) {
        float saturation = foodData.getSaturationLevel();
        int foodLevel = foodData.getFoodLevel();
        int ticks = minecraft.gui.getGuiTicks();
        Random rand = new Random();
        rand.setSeed(ticks * 312871);
        RenderSystem.enableBlend();
        for (int j = 0; j < 10; ++j) {
            int naturalHealingOffset;
            int x = right - j * 8 - 9;
            int y = top;
            if (saturation <= 0.0f && ticks % (foodLevel * 3 + 1) == 0) {
                y = top + (rand.nextInt(3) - 1);
            }
            graphics.blit(MOD_ICONS_TEXTURE, x, y, 0, 0, 9, 9);
            float effectiveHungerOfBar = (float)foodData.getFoodLevel() / 2.0f - (float)j;
            int n = naturalHealingOffset = naturalHealing ? 18 : 0;
            if (effectiveHungerOfBar >= 1.0f) {
                graphics.blit(MOD_ICONS_TEXTURE, x, y, 18 + naturalHealingOffset, 0, 9, 9);
                continue;
            }
            if (!((double)effectiveHungerOfBar >= 0.5)) continue;
            graphics.blit(MOD_ICONS_TEXTURE, x, y, 9 + naturalHealingOffset, 0, 9, 9);
        }
        RenderSystem.disableBlend();
    }

    public static void drawComfortOverlay(Player player, Minecraft minecraft, GuiGraphics graphics, int left, int top) {
        int ticks = minecraft.gui.getGuiTicks();
        Random rand = new Random();
        rand.setSeed(ticks * 312871);
        int health = Mth.ceil((float)player.getHealth());
        float absorb = Mth.ceil((float)player.getAbsorptionAmount());
        AttributeInstance attrMaxHealth = player.getAttribute(Attributes.MAX_HEALTH);
        float healthMax = (float)attrMaxHealth.getValue();
        int regen = -1;
        if (player.hasEffect(MobEffects.REGENERATION)) {
            regen = ticks % 25;
        }
        int healthRows = Mth.ceil((float)((healthMax + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        int comfortSheen = ticks % 50;
        int comfortHeartFrame = comfortSheen % 2;
        int[] textureWidth = new int[]{5, 9};
        RenderSystem.enableBlend();
        int healthMaxSingleRow = Mth.ceil((float)(Math.min(healthMax, 20.0f) / 2.0f));
        int leftHeightOffset = (healthRows - 1) * rowHeight;
        for (int i = 0; i < healthMaxSingleRow; ++i) {
            int column = i % 10;
            int x = left + column * 8;
            int y = top + leftHeightOffset;
            if (health <= 4) {
                y += rand.nextInt(2);
            }
            if (i == regen) {
                y -= 2;
            }
            if (column == comfortSheen / 2) {
                graphics.blit(MOD_ICONS_TEXTURE, x, y, 0, 9, textureWidth[comfortHeartFrame], 9);
            }
            if (column != comfortSheen / 2 - 1 || comfortHeartFrame != 0) continue;
            graphics.blit(MOD_ICONS_TEXTURE, x + 5, y, 5, 9, 4, 9);
        }
        RenderSystem.disableBlend();
    }

    static {
        MOD_ICONS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"textures/gui/fd_icons.png");
    }

    public static class ComfortOverlay
    extends BaseOverlay {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"comfort");

        @Override
        public void render(Minecraft minecraft, Player player, GuiGraphics guiGraphics, int left, int right, int top, int guiTicks) {
            boolean isPlayerEligibleForComfort;
            FoodData stats = player.getFoodData();
            boolean bl = isPlayerEligibleForComfort = stats.getSaturationLevel() == 0.0f && player.isHurt() && !player.hasEffect(MobEffects.REGENERATION);
            if (player.getEffect(ModEffects.COMFORT) != null && isPlayerEligibleForComfort) {
                HUDOverlays.drawComfortOverlay(player, minecraft, guiGraphics, left, top - healthIconsOffset);
            }
        }

        @Override
        public boolean shouldRenderOverlay(Minecraft mc, Player player, GuiGraphics guiGraphics, int guiTicks) {
            if (!super.shouldRenderOverlay(mc, player, guiGraphics, guiTicks)) {
                return false;
            }
            return (Boolean)Configuration.COMFORT_HEALTH_OVERLAY.get();
        }
    }

    public static class NourishmentOverlay
    extends BaseOverlay {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"nourishment");

        @Override
        public void render(Minecraft minecraft, Player player, GuiGraphics guiGraphics, int left, int right, int top, int guiTicks) {
            boolean isPlayerHealingWithSaturation;
            FoodData stats = player.getFoodData();
            boolean bl = isPlayerHealingWithSaturation = player.level().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION) && player.isHurt() && stats.getFoodLevel() >= 18;
            if (player.getEffect(ModEffects.NOURISHMENT) != null) {
                HUDOverlays.drawNourishmentOverlay(stats, minecraft, guiGraphics, right, top - foodIconsOffset, isPlayerHealingWithSaturation);
            }
        }

        @Override
        public boolean shouldRenderOverlay(Minecraft mc, Player player, GuiGraphics guiGraphics, int guiTicks) {
            if (!super.shouldRenderOverlay(mc, player, guiGraphics, guiTicks)) {
                return false;
            }
            return (Boolean)Configuration.NOURISHED_HUNGER_OVERLAY.get();
        }
    }

    public static abstract class BaseOverlay
    implements LayeredDraw.Layer {
        public abstract void render(Minecraft var1, Player var2, GuiGraphics var3, int var4, int var5, int var6, int var7);

        public final void render(@NotNull GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.player == null || !this.shouldRenderOverlay(minecraft, (Player)minecraft.player, guiGraphics, minecraft.gui.getGuiTicks())) {
                return;
            }
            int top = guiGraphics.guiHeight();
            int left = guiGraphics.guiWidth() / 2 - 91;
            int right = guiGraphics.guiWidth() / 2 + 91;
            this.render(minecraft, (Player)minecraft.player, guiGraphics, left, right, top, minecraft.gui.getGuiTicks());
        }

        public boolean shouldRenderOverlay(Minecraft minecraft, Player player, GuiGraphics guiGraphics, int guiTicks) {
            return !minecraft.options.hideGui && minecraft.gameMode != null && minecraft.gameMode.canHurtPlayer();
        }
    }
}

