/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import com.mojang.datafixers.util.Either;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.net.SyncTranslationMessageToClient;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.translation.TranslationKey;
import dev.ftb.mods.ftbquests.util.NetUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;

public record SyncTranslationMessageToServer(long id, String locale, TranslationKey subKey, Either<String, List<String>> val) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncTranslationMessageToServer> TYPE = new CustomPacketPayload.Type(FTBQuestsAPI.rl("sync_translation_to_server"));
    public static StreamCodec<FriendlyByteBuf, SyncTranslationMessageToServer> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, SyncTranslationMessageToServer::id, (StreamCodec)ByteBufCodecs.STRING_UTF8, SyncTranslationMessageToServer::locale, (StreamCodec)NetworkHelper.enumStreamCodec(TranslationKey.class), SyncTranslationMessageToServer::subKey, (StreamCodec)ByteBufCodecs.either((StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.collection(ArrayList::new))), SyncTranslationMessageToServer::val, SyncTranslationMessageToServer::new);

    public static SyncTranslationMessageToServer create(QuestObjectBase obj, String locale, TranslationKey subKey, String text) {
        return new SyncTranslationMessageToServer(obj.id, locale, subKey, subKey.validate((Either<String, List<String>>)Either.left((Object)text)));
    }

    public static SyncTranslationMessageToServer create(QuestObjectBase obj, String locale, TranslationKey subKey, List<String> list) {
        return new SyncTranslationMessageToServer(obj.id, locale, subKey, subKey.validate((Either<String, List<String>>)Either.right(list)));
    }

    public SyncTranslationMessageToClient createResponse() {
        return new SyncTranslationMessageToClient(this.id, this.locale, this.subKey, this.val);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SyncTranslationMessageToServer message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            QuestObjectBase object;
            ServerQuestFile file;
            if (NetUtils.canEdit(context) && (file = ServerQuestFile.INSTANCE).isValid() && (object = file.getBase(message.id)) != null) {
                message.val.ifLeft(str -> file.getTranslationManager().addTranslation(object, message.locale, message.subKey, (String)str)).ifRight(list -> file.getTranslationManager().addTranslation(object, message.locale, message.subKey, (List<String>)list));
                NetworkHelper.sendToAll((MinecraftServer)file.server, (CustomPacketPayload)message.createResponse());
            }
        });
    }
}

