/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.util.PanelPositioning;
import dev.ftb.mods.ftbquests.client.AutoPinTarget;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientConfig;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public enum PinnedQuestsTracker {
    INSTANCE;

    private static final int INTERVAL = 30;
    public static final int VERTICAL_SPACING = 3;
    private final List<FormattedCharSequence> pinnedQuestText = new ArrayList<FormattedCharSequence>();
    private int ticker = 0;
    private boolean showChapterTitle;

    public void tick(ClientQuestFile file) {
        if (++this.ticker >= 30) {
            this.collectPinnedQuests(file);
            this.ticker = 0;
        }
    }

    public void refresh() {
        this.ticker = 30;
    }

    private void collectPinnedQuests(ClientQuestFile file) {
        TeamData data = file.selfTeamData;
        this.showChapterTitle = false;
        ArrayList<Quest> pinnedQuests = new ArrayList<Quest>();
        LongSet pinnedIds = data.getPinnedQuestIds(FTBQuestsClient.getClientPlayer());
        if (!pinnedIds.isEmpty()) {
            if (pinnedIds.contains(1L)) {
                boolean wholeBook = FTBQuestsClientConfig.AUTO_PIN_FOLLOWS.get() == AutoPinTarget.QUEST_BOOK;
                file.forAllQuests(quest -> {
                    if (!data.isCompleted((QuestObject)quest) && quest.isVisible(data) && data.canStartTasks((Quest)quest) && (wholeBook || file.isChapterSelected(quest.getChapter()))) {
                        pinnedQuests.add((Quest)quest);
                    }
                });
                this.showChapterTitle = !wholeBook;
            } else {
                pinnedIds.longStream().mapToObj(file::getQuest).filter(Objects::nonNull).forEach(pinnedQuests::add);
            }
        }
        this.rebuildPinnedText(pinnedQuests, Minecraft.getInstance(), data);
    }

    private void rebuildPinnedText(List<Quest> pinnedQuests, Minecraft mc, TeamData data) {
        this.pinnedQuestText.clear();
        for (int i = 0; i < pinnedQuests.size(); ++i) {
            Quest quest = pinnedQuests.get(i);
            if (i > 0) {
                this.pinnedQuestText.add(FormattedCharSequence.EMPTY);
            }
            this.pinnedQuestText.addAll(mc.font.split(FormattedText.composite((FormattedText[])new FormattedText[]{mc.font.getSplitter().headByWidth((FormattedText)quest.getTitle(), 160, Style.EMPTY.withBold(Boolean.valueOf(true))), Component.literal((String)" ").withStyle(ChatFormatting.DARK_AQUA).append(data.getRelativeProgress(quest) + "%")}), 500));
            for (Task task : quest.getTasks()) {
                if (data.isCompleted(task)) continue;
                this.pinnedQuestText.addAll(mc.font.split(FormattedText.composite((FormattedText[])new FormattedText[]{Component.literal((String)"\u2514").withStyle(ChatFormatting.GRAY), mc.font.getSplitter().headByWidth((FormattedText)task.getMutableTitle().withStyle(ChatFormatting.GRAY), 160, Style.EMPTY.applyFormat(ChatFormatting.GRAY)), Component.literal((String)" ").withStyle(ChatFormatting.GREEN).append(task.formatProgress(data, data.getProgress(task))).append("/").append(task.formatMaxProgress())}), 500));
            }
        }
    }

    void render(Minecraft mc, GuiGraphics graphics) {
        if (this.pinnedQuestText.isEmpty()) {
            return;
        }
        MutableComponent title = Component.translatable((String)"ftbquests.pinned");
        if (this.showChapterTitle) {
            ClientQuestFile.INSTANCE.getQuestScreen().flatMap(QuestScreen::getSelectedChapter).ifPresent(chapter -> title.append(": ").append(chapter.getTitle()));
        }
        int titleWidth = mc.font.width((FormattedText)title);
        int width = titleWidth + 5;
        Objects.requireNonNull(mc.font);
        int height = 9 + 10;
        for (FormattedCharSequence s : this.pinnedQuestText) {
            int n;
            width = Math.max(width, (int)mc.font.getSplitter().stringWidth(s));
            if (s == FormattedCharSequence.EMPTY) {
                n = 3;
            } else {
                Objects.requireNonNull(mc.font);
                n = 9;
            }
            height += n;
        }
        float scale = ((Double)FTBQuestsClientConfig.PINNED_QUESTS_SCALE.get()).floatValue();
        int insetX = (Integer)FTBQuestsClientConfig.PINNED_QUESTS_INSET_X.get();
        int insetY = (Integer)FTBQuestsClientConfig.PINNED_QUESTS_INSET_Y.get();
        PanelPositioning.PanelPos pos = ((PanelPositioning)FTBQuestsClientConfig.PINNED_QUESTS_POS.get()).getPanelPos(mc.getWindow().getGuiScaledWidth(), mc.getWindow().getGuiScaledHeight(), (int)((float)(width += 8) * scale), (int)((float)height * scale), insetX, insetY);
        graphics.pose().pushPose();
        graphics.pose().translate((float)pos.x(), (float)pos.y(), 100.0f);
        graphics.pose().scale(scale, scale, 1.0f);
        GuiHelper.drawHollowRect((GuiGraphics)graphics, (int)0, (int)0, (int)width, (int)height, (Color4I)Color4I.BLACK.withAlpha(100), (boolean)false);
        Color4I.BLACK.withAlpha(100).draw(graphics, 0, 0, width, height);
        Color4I color4I = Color4I.GRAY.withAlpha(50);
        Objects.requireNonNull(mc.font);
        color4I.draw(graphics, 1, 1, width - 2, 9 + 4);
        Objects.requireNonNull(mc.font);
        Color4I.BLACK.draw(graphics, 0, 9 + 4, width, 1);
        graphics.drawString(mc.font, (Component)title, (width - titleWidth) / 2, 4, -256);
        Objects.requireNonNull(mc.font);
        int yPos = 9 + 8;
        for (FormattedCharSequence fcs : this.pinnedQuestText) {
            if (fcs == FormattedCharSequence.EMPTY) {
                yPos += 3;
                continue;
            }
            graphics.drawString(mc.font, fcs, 4, yPos, -1);
            Objects.requireNonNull(mc.font);
            yPos += 9;
        }
        graphics.pose().popPose();
    }
}

