/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.alltheores.content.blocks.sets.vanilla_sets;

import java.util.ArrayList;
import java.util.List;
import net.allthemods.alltheores.content.blocks.sets.ato_sets.ATOFluidSet;
import net.allthemods.alltheores.content.blocks.sets.ato_sets.MekanismSet;
import net.allthemods.alltheores.content.blocks.sets.vanilla_sets.VanillaSet;
import net.allthemods.alltheores.infos.Reference;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;

public class VanillaIngotSet
extends VanillaSet {
    private static final List<VanillaIngotSet> instances = new ArrayList<VanillaIngotSet>();
    public final MekanismSet MEK;
    public final ATOFluidSet FLUID;
    public final TagKey<Item> RAW_TAG;
    public final TagKey<Item> NUGGET_TAG;
    public final TagKey<Item> INGOT_TAG;
    public final TagKey<Block> ORE_BLOCK_TAG;
    public final TagKey<Block> RAW_BLOCK_TAG;
    public final TagKey<Block> BLOCK_TAG;
    public final TagKey<Item> ORE_BLOCK_ITEM_TAG;
    public final TagKey<Item> RAW_BLOCK_ITEM_TAG;
    public final TagKey<Item> BLOCK_ITEM_TAG;
    public final Item RAW;
    public final Item INGOT;
    public final Block RAW_BLOCK;
    public final Block BLOCK;
    public final Item RAW_BLOCK_ITEM;
    public final Item BLOCK_ITEM;

    public static List<VanillaIngotSet> getVanillaIngotSets() {
        return instances;
    }

    public VanillaIngotSet(String name, int fluidColor, Item raw, Block rawBlock, Item ingot, Block block) {
        super(name);
        instances.add(this);
        this.RAW_TAG = ItemTags.create((ResourceLocation)Reference.raw_materials(name));
        this.NUGGET_TAG = ItemTags.create((ResourceLocation)Reference.nugget(name));
        this.INGOT_TAG = ItemTags.create((ResourceLocation)Reference.ingot(name));
        this.ORE_BLOCK_TAG = BlockTags.create((ResourceLocation)Reference.ore(name));
        this.RAW_BLOCK_TAG = BlockTags.create((ResourceLocation)Reference.block(String.format("raw_%s", name)));
        this.BLOCK_TAG = BlockTags.create((ResourceLocation)Reference.block(name));
        this.ORE_BLOCK_ITEM_TAG = ItemTags.create((ResourceLocation)Reference.ore(name));
        this.RAW_BLOCK_ITEM_TAG = ItemTags.create((ResourceLocation)Reference.block(String.format("raw_%s", name)));
        this.BLOCK_ITEM_TAG = ItemTags.create((ResourceLocation)Reference.block(name));
        this.RAW = raw;
        this.INGOT = ingot;
        this.RAW_BLOCK = rawBlock;
        this.BLOCK = block;
        this.RAW_BLOCK_ITEM = block.asItem().getDefaultInstance().getItem();
        this.BLOCK_ITEM = block.asItem().getDefaultInstance().getItem();
        this.MEK = ModList.get().isLoaded("mekanism") ? new MekanismSet(name, fluidColor, block) : null;
        this.FLUID = new ATOFluidSet(name, fluidColor);
    }
}

