/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data.recipe;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.silentchaos512.gems.block.GemLampBlock;
import net.silentchaos512.gems.setup.GemsBlocks;
import net.silentchaos512.gems.setup.GemsItems;
import net.silentchaos512.gems.setup.GemsTags;
import net.silentchaos512.gems.util.Gems;
import net.silentchaos512.lib.data.recipe.LibRecipeProvider;
import net.silentchaos512.lib.util.NameUtils;

public class GemsRecipeProvider
extends LibRecipeProvider {
    public GemsRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> provider) {
        super(packOutput, provider, "silentgems");
    }

    protected void buildRecipes(RecipeOutput consumer) {
        this.registerGemRecipes(consumer);
        this.registerMetals(consumer);
        this.registerFoods(consumer);
        this.registerMisc(consumer);
    }

    private void registerGemRecipes(RecipeOutput consumer) {
        for (Gems gem : Gems.values()) {
            String name = gem.getName();
            this.smeltingAndBlastingRecipes(consumer, name, gem.getModOresItemTag(), (ItemLike)gem.getItem(), 1.0f);
            this.compressionRecipes(consumer, (ItemLike)gem.getBlock(), (ItemLike)gem.getItem(), null);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)gem.getBricks(), (int)12).pattern("###").pattern("#o#").pattern("###").define(Character.valueOf('#'), (ItemLike)Blocks.STONE_BRICKS).define(Character.valueOf('o'), gem.getItemTag()).unlockedBy("has_item", GemsRecipeProvider.has(gem.getItemTag())).save(consumer);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)gem.getTiles(), (int)12).pattern("###").pattern("#o#").pattern("###").define(Character.valueOf('#'), (ItemLike)Blocks.DEEPSLATE_TILES).define(Character.valueOf('o'), gem.getItemTag()).unlockedBy("has_item", GemsRecipeProvider.has(gem.getItemTag())).save(consumer);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)gem.getSmallBricks(), (int)12).pattern("###").pattern("#o#").pattern("###").define(Character.valueOf('#'), (ItemLike)Blocks.BRICKS).define(Character.valueOf('o'), gem.getItemTag()).unlockedBy("has_item", GemsRecipeProvider.has(gem.getItemTag())).save(consumer);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)gem.getPolishedStone(), (int)12).pattern("###").pattern("#o#").pattern("###").define(Character.valueOf('#'), (ItemLike)Blocks.POLISHED_DIORITE).define(Character.valueOf('o'), gem.getItemTag()).unlockedBy("has_item", GemsRecipeProvider.has(gem.getItemTag())).save(consumer);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)gem.getSmoothStone(), (int)12).pattern("###").pattern("#o#").pattern("###").define(Character.valueOf('#'), (ItemLike)Blocks.SMOOTH_STONE).define(Character.valueOf('o'), gem.getItemTag()).unlockedBy("has_item", GemsRecipeProvider.has(gem.getItemTag())).save(consumer);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)gem.getChiseledStone(), (int)12).pattern("###").pattern("#o#").pattern("###").define(Character.valueOf('#'), (ItemLike)Blocks.CHISELED_STONE_BRICKS).define(Character.valueOf('o'), gem.getItemTag()).unlockedBy("has_item", GemsRecipeProvider.has(gem.getItemTag())).save(consumer);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)gem.getGlass(), (int)12).pattern("###").pattern("#o#").pattern("###").define(Character.valueOf('#'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('o'), gem.getItemTag()).unlockedBy("has_item", GemsRecipeProvider.has(gem.getItemTag())).save(consumer);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)gem.getLamp(GemLampBlock.State.OFF)).pattern("rgr").pattern("gog").pattern("rgr").define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('g'), Tags.Items.DUSTS_GLOWSTONE).define(Character.valueOf('o'), gem.getItemTag()).unlockedBy("has_item", GemsRecipeProvider.has(gem.getItemTag())).save(consumer);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)gem.getLamp(GemLampBlock.State.INVERTED_ON)).requires((ItemLike)gem.getLamp(GemLampBlock.State.OFF)).requires((ItemLike)Items.REDSTONE_TORCH).unlockedBy("has_item", GemsRecipeProvider.has(gem.getItemTag())).save(consumer);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, gem.getTeleporter(), (int)2).pattern("igi").pattern("gcg").pattern(" e ").define(Character.valueOf('c'), GemsBlocks.CHAOS_ESSENCE_BLOCK).define(Character.valueOf('g'), gem.getItemTag()).define(Character.valueOf('e'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('i'), Tags.Items.INGOTS_GOLD).unlockedBy("has_item", GemsRecipeProvider.has(GemsItems.CHAOS_ESSENCE)).save(consumer);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, gem.getRedstoneTeleporter()).requires(gem.getTeleporter()).requires(Tags.Items.DUSTS_REDSTONE).unlockedBy("has_item", GemsRecipeProvider.has(gem.getTeleporter())).save(consumer);
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, GemsBlocks.TELEPORTER_ANCHOR, (int)4).pattern("igi").pattern("gcg").pattern(" e ").define(Character.valueOf('c'), GemsBlocks.CHAOS_ESSENCE_BLOCK).define(Character.valueOf('i'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('e'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('g'), GemsTags.Items.INGOTS_SILVER).unlockedBy("has_item", GemsRecipeProvider.has(GemsItems.CHAOS_ESSENCE)).save(consumer);
        this.glowroseToDye(consumer, Gems.RUBY, (ItemLike)Items.RED_DYE);
        this.glowroseToDye(consumer, Gems.CARNELIAN, (ItemLike)Items.RED_DYE);
        this.glowroseToDye(consumer, Gems.TOPAZ, (ItemLike)Items.ORANGE_DYE);
        this.glowroseToDye(consumer, Gems.CITRINE, (ItemLike)Items.YELLOW_DYE);
        this.glowroseToDye(consumer, Gems.HELIODOR, (ItemLike)Items.YELLOW_DYE);
        this.glowroseToDye(consumer, Gems.MOLDAVITE, (ItemLike)Items.LIME_DYE);
        this.glowroseToDye(consumer, Gems.PERIDOT, (ItemLike)Items.GREEN_DYE);
        this.glowroseToDye(consumer, Gems.TURQUOISE, (ItemLike)Items.CYAN_DYE);
        this.glowroseToDye(consumer, Gems.KYANITE, (ItemLike)Items.LIGHT_BLUE_DYE);
        this.glowroseToDye(consumer, Gems.SAPPHIRE, (ItemLike)Items.BLUE_DYE);
        this.glowroseToDye(consumer, Gems.IOLITE, (ItemLike)Items.PURPLE_DYE);
        this.glowroseToDye(consumer, Gems.ALEXANDRITE, (ItemLike)Items.PURPLE_DYE);
        this.glowroseToDye(consumer, Gems.AMMOLITE, (ItemLike)Items.MAGENTA_DYE);
        this.glowroseToDye(consumer, Gems.ROSE_QUARTZ, (ItemLike)Items.PINK_DYE);
        this.glowroseToDye(consumer, Gems.BLACK_DIAMOND, (ItemLike)Items.BLACK_DYE);
        this.glowroseToDye(consumer, Gems.WHITE_DIAMOND, (ItemLike)Items.WHITE_DYE);
        this.glowroseToDye(consumer, Gems.AQUAMARINE, (ItemLike)Items.LIGHT_BLUE_DYE);
        this.glowroseToDye(consumer, Gems.GARNET, (ItemLike)Items.RED_DYE);
        this.glowroseToDye(consumer, Gems.OPAL, (ItemLike)Items.WHITE_DYE);
        this.glowroseToDye(consumer, Gems.PEARL, (ItemLike)Items.WHITE_DYE);
        this.glowroseToDye(consumer, Gems.TANZANITE, (ItemLike)Items.PURPLE_DYE);
    }

    private void glowroseToDye(RecipeOutput consumer, Gems gem, ItemLike dye) {
        String dyeName = NameUtils.fromItem((ItemLike)dye).getPath();
        String glowroseName = NameUtils.fromItem((ItemLike)gem.getGlowrose()).getPath();
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)dye, (int)1).requires(gem.getGlowroseItemTag()).unlockedBy("has_item", GemsRecipeProvider.has(gem.getGlowroseItemTag())).save(consumer, this.modId(dyeName + "_from_" + glowroseName));
    }

    private void registerMetals(RecipeOutput consumer) {
        this.smeltingAndBlastingRecipes(consumer, "silver_ingot", (ItemLike)GemsItems.RAW_SILVER.get(), (ItemLike)GemsItems.SILVER_INGOT.get(), 1.0f);
        this.compressionRecipes(consumer, (ItemLike)GemsBlocks.SILVER_BLOCK.get(), (ItemLike)GemsItems.SILVER_INGOT.get(), (ItemLike)GemsItems.SILVER_NUGGET.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, GemsItems.SILVER_ROD, (int)4).pattern("#").pattern("#").define(Character.valueOf('#'), GemsTags.Items.INGOTS_SILVER).unlockedBy("has_item", GemsRecipeProvider.has(GemsTags.Items.INGOTS_SILVER)).save(consumer);
        this.compressionRecipes(consumer, (ItemLike)GemsBlocks.CHAOS_ESSENCE_BLOCK.get(), (ItemLike)GemsItems.CHAOS_ESSENCE.get(), null);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, GemsItems.REINFORCED_GOLD_ROD, (int)2).pattern("/").pattern("i").pattern("c").define(Character.valueOf('/'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('c'), GemsItems.CHAOS_ESSENCE).unlockedBy("has_item", GemsRecipeProvider.has(GemsItems.CHAOS_ESSENCE)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, GemsItems.REINFORCED_SILVER_ROD, (int)2).pattern("/").pattern("i").pattern("c").define(Character.valueOf('/'), GemsTags.Items.INGOTS_SILVER).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('c'), GemsItems.CHAOS_ESSENCE).unlockedBy("has_item", GemsRecipeProvider.has(GemsItems.CHAOS_ESSENCE)).save(consumer);
    }

    private void registerFoods(RecipeOutput consumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, GemsItems.POTATO_ON_A_STICK).pattern(" p").pattern("/ ").define(Character.valueOf('p'), (ItemLike)Items.BAKED_POTATO).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", GemsRecipeProvider.has((ItemLike)Items.BAKED_POTATO)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, GemsItems.SUGAR_COOKIE, (int)8).pattern(" S ").pattern("///").pattern(" S ").define(Character.valueOf('S'), (ItemLike)Items.SUGAR).define(Character.valueOf('/'), (ItemLike)Items.WHEAT).unlockedBy("has_item", GemsRecipeProvider.has((ItemLike)Items.SUGAR)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, GemsItems.IRON_POTATO).pattern("/#/").pattern("#p#").pattern("/#/").define(Character.valueOf('/'), Tags.Items.GEMS).define(Character.valueOf('#'), Tags.Items.STORAGE_BLOCKS_IRON).define(Character.valueOf('p'), (ItemLike)Items.POTATO).unlockedBy("has_item", GemsRecipeProvider.has((ItemLike)Items.POTATO)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, GemsItems.UNCOOKED_FISHY_STEW).requires((ItemLike)Items.BOWL).requires(GemsTags.Items.STEW_FISH).requires((ItemLike)Items.DRIED_KELP).requires((ItemLike)Items.BROWN_MUSHROOM).unlockedBy("has_item", GemsRecipeProvider.has(GemsTags.Items.STEW_FISH)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, GemsItems.UNCOOKED_MEATY_STEW).requires((ItemLike)Items.BOWL).requires(GemsTags.Items.STEW_MEAT).requires((ItemLike)Items.POTATO).requires((ItemLike)Items.CARROT).unlockedBy("has_item", GemsRecipeProvider.has(GemsTags.Items.STEW_MEAT)).save(consumer);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{GemsItems.UNCOOKED_FISHY_STEW}), (RecipeCategory)RecipeCategory.FOOD, GemsItems.FISHY_STEW, (float)0.45f, (int)200).unlockedBy("has_item", GemsRecipeProvider.has(GemsTags.Items.STEW_FISH)).save(consumer);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{GemsItems.UNCOOKED_MEATY_STEW}), (RecipeCategory)RecipeCategory.FOOD, GemsItems.MEATY_STEW, (float)0.45f, (int)200).unlockedBy("has_item", GemsRecipeProvider.has(GemsTags.Items.STEW_MEAT)).save(consumer);
    }

    private void registerMisc(RecipeOutput consumer) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, GemsItems.SPARKLING_BONE_MEAL, (int)8).requires(GemsTags.Items.GEMS).requires((ItemLike)Items.BONE_MEAL, 3).unlockedBy("has_item", GemsRecipeProvider.has(GemsTags.Items.GEMS)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, GemsItems.TELEPORTER_LINKER).pattern("#").pattern("/").define(Character.valueOf('#'), GemsItems.CHAOS_ESSENCE).define(Character.valueOf('/'), GemsTags.Items.RODS_SILVER).unlockedBy("has_item", GemsRecipeProvider.has(GemsItems.CHAOS_ESSENCE)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, GemsItems.SUMMON_KITTY).pattern("|f|").pattern("|g|").pattern("|f|").define(Character.valueOf('|'), Tags.Items.STRINGS).define(Character.valueOf('f'), GemsTags.Items.STEW_FISH).define(Character.valueOf('g'), GemsTags.Items.GEMS).unlockedBy("has_item", GemsRecipeProvider.has(GemsTags.Items.GEMS)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, GemsItems.SUMMON_PUPPY).pattern(" m ").pattern("#g#").pattern(" m ").define(Character.valueOf('m'), GemsTags.Items.STEW_FISH).define(Character.valueOf('#'), Tags.Items.LEATHERS).define(Character.valueOf('g'), GemsTags.Items.GEMS).unlockedBy("has_item", GemsRecipeProvider.has(GemsTags.Items.GEMS)).save(consumer);
    }
}

