/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.type.source;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.refinedtypes.TypeRenderer;
import com.ultramega.refinedtypes.type.Type;
import com.ultramega.refinedtypes.type.source.SourceResource;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class SourceResourceRendering
implements ResourceRendering {
    private static final DecimalFormat FORMATTER = new DecimalFormat("#,###.###", DecimalFormatSymbols.getInstance(Locale.US));
    private final long bucketAmount;

    public SourceResourceRendering(long bucketAmount) {
        this.bucketAmount = bucketAmount;
    }

    public String formatAmount(long amount, boolean withUnits) {
        return (!withUnits ? SourceResourceRendering.format(amount, this.bucketAmount) : SourceResourceRendering.formatWithUnits(amount, this.bucketAmount)) + "B";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component getDisplayName(ResourceKey resourceKey) {
        if (!(resourceKey instanceof SourceResource)) return Component.empty();
        SourceResource sourceResource = (SourceResource)resourceKey;
        try {
            Type type;
            Type type2 = type = sourceResource.type();
            return type2.getDisplayName();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Component> getTooltip(ResourceKey resourceKey) {
        Type type2;
        if (!(resourceKey instanceof SourceResource)) return Collections.emptyList();
        SourceResource sourceResource = (SourceResource)resourceKey;
        try {
            Type type;
            type2 = type = sourceResource.type();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return List.of(type2.getDisplayName());
    }

    public void render(ResourceKey resourceKey, GuiGraphics graphics, int x, int y) {
        if (resourceKey instanceof SourceResource) {
            Type type;
            SourceResource sourceResource = (SourceResource)resourceKey;
            try {
                Type type2;
                type = type2 = sourceResource.type();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            TypeRenderer.render(graphics.pose(), x, y, type);
        }
    }

    public void render(ResourceKey resourceKey, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, Level level) {
        if (resourceKey instanceof SourceResource) {
            Type type;
            SourceResource sourceResource = (SourceResource)resourceKey;
            try {
                Type type2;
                type = type2 = sourceResource.type();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            TypeRenderer.render(poseStack, multiBufferSource, light, type);
        }
    }

    private static String formatWithUnits(long droplets, long bucketAmount) {
        double buckets = SourceResourceRendering.convertToBuckets(droplets, bucketAmount);
        return IdentifierUtil.formatWithUnits((double)buckets);
    }

    private static String format(long droplets, long bucketAmount) {
        double buckets = SourceResourceRendering.convertToBuckets(droplets, bucketAmount);
        return FORMATTER.format(buckets);
    }

    private static double convertToBuckets(long droplets, long bucketAmount) {
        return (double)droplets / (double)bucketAmount;
    }
}

