/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.storage.source;

import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.storage.AbstractStorageContainerItem;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItemHelper;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.refinedmods.refinedstorage.common.storage.UpgradeableStorageContainer;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.refinedtypes.RefinedTypesUtil;
import com.ultramega.refinedtypes.registry.Items;
import com.ultramega.refinedtypes.storage.source.SourceStorageBlockBlockItem;
import com.ultramega.refinedtypes.storage.source.SourceStorageVariant;
import com.ultramega.refinedtypes.type.source.SourceResource;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SourceStorageDiskItem
extends AbstractStorageContainerItem
implements UpgradeableStorageContainer {
    private static final Component INFINITE_HELP = RefinedTypesUtil.createRefinedTypesTranslation("item", "infinite_source_storage_disk.help");
    private final SourceStorageVariant variant;
    private final Component helpText;

    public SourceStorageDiskItem(StorageContainerItemHelper helper, SourceStorageVariant variant) {
        super(new Item.Properties().stacksTo(1).fireResistant(), helper);
        this.variant = variant;
        this.helpText = SourceStorageDiskItem.getHelpText(variant);
    }

    private static Component getHelpText(SourceStorageVariant variant) {
        if (variant.getCapacity() == null) {
            return INFINITE_HELP;
        }
        return RefinedTypesUtil.createRefinedTypesTranslation("item", "source_storage_disk.help", IdentifierUtil.format((long)variant.getCapacity()));
    }

    @Nullable
    protected Long getCapacity() {
        return this.variant.getCapacity();
    }

    protected String formatAmount(long amount) {
        return RefinedStorageClientApi.INSTANCE.getResourceRendering(SourceResource.class).formatAmount(amount);
    }

    protected SerializableStorage createStorage(StorageRepository storageRepository) {
        return SourceStorageBlockBlockItem.createStorage(this.variant, () -> ((StorageRepository)storageRepository).markAsChanged());
    }

    protected ItemStack createPrimaryDisassemblyByproduct(int count) {
        return new ItemStack((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getStorageHousing(), count);
    }

    protected ItemStack createSecondaryDisassemblyByproduct(int count) {
        return new ItemStack((ItemLike)Items.getSourceStoragePart(this.variant), count);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new HelpTooltipComponent(this.helpText));
    }

    public StorageVariant getVariant() {
        return this.variant;
    }

    public void transferTo(ItemStack from, ItemStack to) {
        this.helper.markAsToTransfer(from, to);
    }
}

