/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.config;

import java.util.List;
import java.util.function.Predicate;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class ConfigHelper {

    public static class CategoryBuilder {
        private final ModConfigSpec.Builder builder;
        private String category;

        public void push(String ... comment) {
            this.builder.comment(comment).translation("ars_controle.config." + this.category).push(this.category);
        }

        public void pop() {
            this.builder.pop();
        }

        public CategoryBuilder child(String category) {
            return new CategoryBuilder(this.builder, category);
        }

        public <T> ModConfigSpec.ConfigValue<T> make(String name, T defaultValue, String ... comment) {
            return this.builder.comment(comment).translation("ars_controle.config." + this.category + "." + name).define(name, defaultValue);
        }

        public ModConfigSpec.ConfigValue<List<? extends String>> makeStringList(String name, List<String> defaultValue, String defaultElement, Predicate<String> valid, String ... comment) {
            return this.builder.comment(comment).translation("ars_controle.config." + this.category + "." + name).defineListAllowEmpty(name, defaultValue, () -> defaultElement, o -> {
                String s;
                return o instanceof String && valid.test(s = (String)o);
            });
        }

        public <T extends Comparable<? super T>> ModConfigSpec.ConfigValue<T> makeBounded(String name, T defaultValue, T min, T max, Class<T> clazz, String ... comment) {
            return this.builder.comment(comment).translation("ars_controle.config." + this.category + "." + name).defineInRange(name, defaultValue, min, max, clazz);
        }

        public ModConfigSpec.BooleanValue bool(String name, boolean defaultValue, String ... comment) {
            return this.builder.comment(comment).translation("ars_controle.config." + this.category + "." + name).define(name, defaultValue);
        }

        public CategoryBuilder setCategory(@NotNull String category) {
            this.category = category;
            return this;
        }

        public String getCategory() {
            return this.category;
        }

        public CategoryBuilder(ModConfigSpec.Builder builder, String category) {
            this.builder = builder;
            this.category = category;
        }
    }
}

