/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.block.tile;

import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import dev.qther.ars_controle.block.tile.IDimensionalHighlighter;
import dev.qther.ars_controle.config.ACServerConfig;
import dev.qther.ars_controle.datagen.ACBlockTagProvider;
import dev.qther.ars_controle.registry.ACRegistry;
import dev.qther.ars_controle.util.Cached;
import it.unimi.dsi.fastutil.Pair;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScryersLinkageTile
extends ModdedTile
implements IWandable,
IDimensionalHighlighter,
Container {
    public ScryersLinkageTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACRegistry.Tiles.SCRYERS_LINKAGE.get(), pos, state);
    }

    @Nullable
    public GlobalPos getTarget() {
        Pair<Level, BlockPos> info = this.getTargetInfo();
        if (info == null) {
            return null;
        }
        return new GlobalPos(((Level)info.first()).dimension(), (BlockPos)info.second());
    }

    @Nullable
    public Pair<Level, BlockPos> getTargetInfo() {
        if (this.level == null) {
            return null;
        }
        Level targetLevel = this.getTargetLevel();
        BlockPos targetPos = this.getTargetBlock();
        if (targetLevel == null || targetPos == null) {
            return null;
        }
        Block block = targetLevel.getBlockState(targetPos).getBlock();
        if (BuiltInRegistries.BLOCK.wrapAsHolder((Object)block).is(ACBlockTagProvider.SCRYERS_LINKAGE_BLACKLIST)) {
            this.removeBlock();
            return null;
        }
        return Pair.of((Object)targetLevel, (Object)targetPos);
    }

    public boolean hasTarget() {
        if (this.level == null) {
            return false;
        }
        CompoundTag tag = this.getPersistentData();
        return tag.contains("block", 4);
    }

    public boolean setBlock(@NotNull Level level, @NotNull BlockPos block) {
        Level thisLevel = this.getLevel();
        if (thisLevel == null) {
            return false;
        }
        BlockState target = level.getBlockState(block);
        if (BuiltInRegistries.BLOCK.wrapAsHolder((Object)target.getBlock()).is(ACBlockTagProvider.SCRYERS_LINKAGE_BLACKLIST)) {
            return false;
        }
        CompoundTag tag = this.getPersistentData();
        tag.putString("dimension", level.dimension().location().toString());
        tag.putLong("block", block.asLong());
        this.notifyChange();
        return true;
    }

    public void removeBlock() {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        CompoundTag tag = this.getPersistentData();
        tag.remove("dimension");
        tag.remove("block");
        this.notifyChange();
    }

    private void notifyChange() {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        this.setChanged();
        this.invalidateCapabilities();
        BlockPos pos = this.getBlockPos();
        BlockState state = this.getBlockState();
        Block thisBlock = state.getBlock();
        level.updateNeighborsAt(pos, thisBlock);
        level.updateNeighbourForOutputSignal(pos, thisBlock);
        state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
    }

    @Nullable
    private Level getTargetLevel() {
        String s;
        if (this.level == null) {
            return null;
        }
        CompoundTag tag = this.getPersistentData();
        String string = s = tag.contains("dimension", 8) ? tag.getString("dimension") : null;
        if (s == null) {
            return null;
        }
        if (s.equals(this.level.dimension().location().toString())) {
            return this.level;
        }
        if (this.level.isClientSide) {
            return null;
        }
        return Cached.getLevelByName(s);
    }

    @Nullable
    private BlockPos getTargetBlock() {
        if (this.level == null) {
            return null;
        }
        CompoundTag tag = this.getPersistentData();
        return tag.contains("block", 4) ? BlockPos.of((long)tag.getLong("block")) : null;
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        Level level;
        super.saveAdditional(tag, registries);
        BlockPos pos = this.getTargetBlock();
        if (pos != null) {
            tag.putLong("block", pos.asLong());
        }
        if ((level = this.getTargetLevel()) != null) {
            tag.putString("dimension", level.dimension().location().toString());
        }
    }

    public IWandable.Result onLastConnection(@Nullable GlobalPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player player) {
        if (!(player instanceof ServerPlayer)) {
            return IWandable.Result.FAIL;
        }
        if (storedPos == null) {
            return IWandable.Result.FAIL;
        }
        ServerLevel level = Cached.getLevelByKey((ResourceKey<Level>)storedPos.dimension());
        if (level == null) {
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.remote.error.invalid_dimension"));
            return IWandable.Result.FAIL;
        }
        if (!this.setBlock((Level)level, storedPos.pos())) {
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.remote.error.invalid_target"));
            return IWandable.Result.FAIL;
        }
        PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.set.block", (Object[])new Object[]{storedPos.pos().toShortString(), level.dimension().location().toString()}));
        return IWandable.Result.SUCCESS;
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player player) {
        if (storedPos != null) {
            Level level = player.level();
            if (this.setBlock(level, storedPos)) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.set.block", (Object[])new Object[]{storedPos.toShortString(), level.dimension().location().toString()}));
            } else {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.remote.error.invalid_target"));
            }
        }
    }

    public List<ColorPos> getWandHighlight(List<ColorPos> list) {
        BlockPos target = this.getTargetBlock();
        if (target != null) {
            list.add(ColorPos.centered((BlockPos)target));
        }
        return list;
    }

    @Override
    public List<ColorPos> getWandHighlight(Level level, List<ColorPos> list) {
        Pair<Level, BlockPos> target = this.getTargetInfo();
        if (target != null && target.first() == level) {
            list.add(ColorPos.centered((BlockPos)((BlockPos)target.second())));
        }
        return list;
    }

    @Nullable
    private <T> T getTargetAs(Class<T> clazz) {
        BlockEntity be;
        Pair<Level, BlockPos> info = this.getTargetInfo();
        if (info == null) {
            return null;
        }
        Level level = (Level)info.first();
        BlockPos pos = (BlockPos)info.second();
        ChunkPos loadPos = new ChunkPos(pos);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int loadTime = (Integer)ACServerConfig.SERVER.WARPING_SPELL_PRISM_LOAD_TIME.get();
            if (loadTime > 0) {
                serverLevel.getChunkSource().addRegionTicket(TicketType.create((String)"scryers_linkage", Comparator.comparingLong(ChunkPos::toLong), (int)loadTime), loadPos, 1, (Object)loadPos, true);
            }
        }
        if ((be = level.getBlockEntity(pos)) == null || BuiltInRegistries.BLOCK.wrapAsHolder((Object)be.getBlockState().getBlock()).is(ACBlockTagProvider.SCRYERS_LINKAGE_BLACKLIST)) {
            return null;
        }
        if (clazz.isAssignableFrom(be.getClass())) {
            return clazz.cast(be);
        }
        return null;
    }

    public int getContainerSize() {
        Container container = this.getTargetAs(Container.class);
        return container == null ? 0 : container.getContainerSize();
    }

    public boolean isEmpty() {
        Container container = this.getTargetAs(Container.class);
        return container == null || container.isEmpty();
    }

    @NotNull
    public ItemStack getItem(int i) {
        Container container = this.getTargetAs(Container.class);
        return container == null ? ItemStack.EMPTY : container.getItem(i);
    }

    @NotNull
    public ItemStack removeItem(int i, int i1) {
        Container container = this.getTargetAs(Container.class);
        return container == null ? ItemStack.EMPTY : container.removeItem(i, i1);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int i) {
        Container container = this.getTargetAs(Container.class);
        return container == null ? ItemStack.EMPTY : container.removeItemNoUpdate(i);
    }

    public void setItem(int i, @NotNull ItemStack itemStack) {
        Container container = this.getTargetAs(Container.class);
        if (container != null) {
            container.setItem(i, itemStack);
        }
    }

    public boolean stillValid(@NotNull Player player) {
        Container container = this.getTargetAs(Container.class);
        return container != null && container.stillValid(player);
    }

    public void clearContent() {
        Container container = this.getTargetAs(Container.class);
        if (container != null) {
            container.clearContent();
        }
    }
}

