/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.screen;

import net.minecraft.util.FastColor;

class Particle2D {
    float x;
    float y;
    float dx;
    float dy;
    float lifetime;
    float age = 0.0f;
    float size;
    float flickerOffset;

    public Particle2D(float x, float y, float dx, float dy, float lifetime) {
        this.x = x;
        this.y = y;
        this.dx = dx;
        this.dy = dy;
        this.lifetime = lifetime;
        this.size = 2.0f + (float)Math.random() * 2.0f;
        this.flickerOffset = (float)Math.random() * (float)Math.PI * 2.0f;
    }

    public void update(float delta) {
        this.x += this.dx * delta;
        this.y += this.dy * delta;
        this.age += delta;
    }

    public boolean isAlive(int menuLeft, int menuTop, int menuRight, int menuBottom) {
        boolean insideMenu = this.x >= (float)menuLeft && this.x <= (float)menuRight && this.y >= (float)menuTop && this.y <= (float)menuBottom;
        return this.age < this.lifetime && !insideMenu;
    }

    public int getColor() {
        float flicker = 0.5f + 0.5f * (float)Math.sin(this.age * 12.0f + this.flickerOffset);
        int alpha = (int)(255.0f * (1.0f - this.age / this.lifetime) * flicker);
        return FastColor.ARGB32.color((int)alpha, (int)(120 + (int)(flicker * 80.0f)), (int)0, (int)(180 + (int)(flicker * 75.0f)));
    }
}

