/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.screen;

import com.sts15.enderdrives.screen.EnderDiskFrequencyScreen;
import com.sts15.enderdrives.screen.TransferMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

class CustomImageCycleButton
extends Button {
    private int currentMode;

    public CustomImageCycleButton(int x, int y, int width, int height, Button.OnPress onPress, int initial) {
        super(x, y, width, height, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
        this.currentMode = initial;
    }

    public void setMode(int mode) {
        this.currentMode = mode;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation texture = this.getTexture(this.currentMode, this.isHovered);
        graphics.blit(texture, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        if (this.isHovered) {
            graphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)TransferMode.getTranslationKey(this.currentMode)), mouseX, mouseY);
        }
    }

    private ResourceLocation getTexture(int mode, boolean hover) {
        return switch (mode) {
            case 1 -> {
                if (hover) {
                    yield this.getInputHoverTexture();
                }
                yield this.getInputTexture();
            }
            case 2 -> {
                if (hover) {
                    yield this.getOutputHoverTexture();
                }
                yield this.getOutputTexture();
            }
            default -> hover ? this.getBidirectionalHoverTexture() : this.getBidirectionalTexture();
        };
    }

    private ResourceLocation getInputTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)(EnderDiskFrequencyScreen.useAltTheme ? "textures/gui/transport_input_alt.png" : "textures/gui/transport_input.png"));
    }

    private ResourceLocation getInputHoverTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)(EnderDiskFrequencyScreen.useAltTheme ? "textures/gui/transport_input_hover_alt.png" : "textures/gui/transport_input_hover.png"));
    }

    private ResourceLocation getOutputTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)(EnderDiskFrequencyScreen.useAltTheme ? "textures/gui/transport_output_alt.png" : "textures/gui/transport_output.png"));
    }

    private ResourceLocation getOutputHoverTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)(EnderDiskFrequencyScreen.useAltTheme ? "textures/gui/transport_output_hover_alt.png" : "textures/gui/transport_output_hover.png"));
    }

    private ResourceLocation getBidirectionalTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)(EnderDiskFrequencyScreen.useAltTheme ? "textures/gui/transport_bidirectional_alt.png" : "textures/gui/transport_bidirectional.png"));
    }

    private ResourceLocation getBidirectionalHoverTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)(EnderDiskFrequencyScreen.useAltTheme ? "textures/gui/transport_bidirectional_hover_alt.png" : "textures/gui/transport_bidirectional_hover.png"));
    }
}

