/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.network;

import com.sts15.enderdrives.network.packet.RequestDiskTypeCountPacket;
import com.sts15.enderdrives.network.packet.RequestTapeTypeCountPacket;
import com.sts15.enderdrives.network.packet.SyncConfigPacket;
import com.sts15.enderdrives.network.packet.SyncDisabledDrivesPacket;
import com.sts15.enderdrives.network.packet.UpdateDiskTypeCountPacket;
import com.sts15.enderdrives.network.packet.UpdateFrequencyPacket;
import com.sts15.enderdrives.network.packet.UpdateTapeTypeCountPacket;
import com.sts15.enderdrives.screen.FrequencyScope;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public class NetworkHandler {
    public static void registerPackets(@NotNull RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("enderdrives").versioned("1.0").optional();
        registrar.playToClient(SyncConfigPacket.TYPE, SyncConfigPacket.STREAM_CODEC, SyncConfigPacket::handle);
        registrar.playToClient(SyncDisabledDrivesPacket.TYPE, SyncDisabledDrivesPacket.STREAM_CODEC, SyncDisabledDrivesPacket::handle);
        registrar.playToClient(UpdateDiskTypeCountPacket.TYPE, UpdateDiskTypeCountPacket.STREAM_CODEC.cast(), UpdateDiskTypeCountPacket::handle);
        registrar.playToServer(RequestDiskTypeCountPacket.TYPE, RequestDiskTypeCountPacket.STREAM_CODEC, RequestDiskTypeCountPacket::handle);
        registrar.playToServer(UpdateFrequencyPacket.TYPE, UpdateFrequencyPacket.STREAM_CODEC, UpdateFrequencyPacket::handle);
        registrar.playToServer(RequestTapeTypeCountPacket.TYPE, RequestTapeTypeCountPacket.STREAM_CODEC, RequestTapeTypeCountPacket::handle);
        registrar.playToClient(UpdateTapeTypeCountPacket.TYPE, UpdateTapeTypeCountPacket.STREAM_CODEC.cast(), UpdateTapeTypeCountPacket::handle);
    }

    public static void sendFrequencyUpdateToServer(int frequency, FrequencyScope scope, int transferMode) {
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateFrequencyPacket(frequency, scope, transferMode), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void requestDiskTypeCount(String scopePrefix, int frequency, int typeLimit) {
        PacketDistributor.sendToServer((CustomPacketPayload)new RequestDiskTypeCountPacket(scopePrefix, frequency, typeLimit), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToClient(ServerPlayer player, UpdateDiskTypeCountPacket packet) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToClient(ServerPlayer player, CustomPacketPayload packet) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToServer(UUID id) {
        PacketDistributor.sendToServer((CustomPacketPayload)new RequestTapeTypeCountPacket(id.getMostSignificantBits(), id.getLeastSignificantBits()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

