/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;

public enum BlockRenderLayer {
    SOLID(RenderType::solid),
    CUTOUT(RenderType::cutout),
    CUTOUT_MIPPED(RenderType::cutoutMipped),
    TRANSLUCENT(RenderType::translucent),
    TRIPWIRE(RenderType::tripwire);

    private static final Map<RenderType, BlockRenderLayer> reverseLookup;
    private final RenderType renderType;

    private BlockRenderLayer(Supplier<RenderType> renderType) {
        this.renderType = renderType.get();
    }

    public static BlockRenderLayer fromType(RenderType layer) {
        return reverseLookup.get(layer);
    }

    private BlockRenderLayer(RenderType renderType) {
        this.renderType = renderType;
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    static {
        reverseLookup = new IdentityHashMap<RenderType, BlockRenderLayer>();
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            reverseLookup.put(layer.getRenderType(), layer);
        }
    }
}

