/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.render;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import team.chisel.ctm.api.texture.ISubmap;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.api.util.TextureInfo;
import team.chisel.ctm.client.texture.ctx.TextureContextCTM;
import team.chisel.ctm.client.texture.render.TextureCTM;
import team.chisel.ctm.client.texture.type.TextureTypePlane;
import team.chisel.ctm.client.util.CTMLogic;
import team.chisel.ctm.client.util.Dir;
import team.chisel.ctm.client.util.Quad;
import team.chisel.ctm.client.util.Submap;

public class TexturePlane
extends TextureCTM<TextureTypePlane> {
    private final Direction.Plane plane;

    public TexturePlane(TextureTypePlane type, TextureInfo info) {
        super(type, info);
        this.plane = type.getPlane();
    }

    @Override
    public List<BakedQuad> transformQuad(BakedQuad bakedQuad, ITextureContext context, int quads) {
        CTMLogic cTMLogic;
        Quad quad = this.makeQuad(bakedQuad, context);
        if (context instanceof TextureContextCTM) {
            TextureContextCTM ctmContext = (TextureContextCTM)context;
            cTMLogic = ctmContext.getCTM(bakedQuad.getDirection());
        } else {
            cTMLogic = null;
        }
        CTMLogic logic = cTMLogic;
        return Collections.singletonList(quad.transformUVs(this.sprites[0], this.getQuad(logic)).rebake());
    }

    private ISubmap getQuad(CTMLogic logic) {
        int v;
        int u;
        if (logic == null) {
            return Submap.X2[0][0];
        }
        if (this.plane == Direction.Plane.VERTICAL) {
            boolean top = logic.connected(Dir.TOP);
            u = top == logic.connected(Dir.BOTTOM) ? 0 : 1;
            v = top ? 1 : 0;
        } else {
            boolean left = logic.connected(Dir.LEFT);
            u = left ? 1 : 0;
            v = left == logic.connected(Dir.RIGHT) ? 0 : 1;
        }
        return Submap.X2[v][u];
    }
}

