/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.ctx;

import com.google.common.collect.ObjectArrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.ArrayUtils;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.client.util.ConnectionLocations;

public class TextureContextPillar
implements ITextureContext {
    private static final ConnectionLocations[] MAIN_VALUES = new ConnectionLocations[]{ConnectionLocations.UP, ConnectionLocations.DOWN, ConnectionLocations.NORTH, ConnectionLocations.SOUTH, ConnectionLocations.EAST, ConnectionLocations.WEST};
    private static final ConnectionLocations[] OFFSET_VALUES = (ConnectionLocations[])ArrayUtils.removeElements((Object[])ConnectionLocations.VALUES, (Object[])((ConnectionLocations[])ObjectArrays.concat((Object[])new ConnectionLocations[]{ConnectionLocations.NORTH_EAST_UP, ConnectionLocations.NORTH_EAST_DOWN, ConnectionLocations.NORTH_WEST_UP, ConnectionLocations.NORTH_WEST_DOWN, ConnectionLocations.SOUTH_WEST_UP, ConnectionLocations.SOUTH_WEST_DOWN, ConnectionLocations.SOUTH_EAST_UP, ConnectionLocations.SOUTH_EAST_DOWN}, (Object[])MAIN_VALUES, ConnectionLocations.class)));
    private static final ConnectionLocations[] ALL_VALUES = (ConnectionLocations[])ObjectArrays.concat((Object[])MAIN_VALUES, (Object[])OFFSET_VALUES, ConnectionLocations.class);
    private ConnectionData data;
    private long compressedData;

    public TextureContextPillar(BlockGetter world, BlockPos pos) {
        this.data = new ConnectionData(world, pos);
        BlockState state = world.getBlockState(pos);
        for (ConnectionLocations loc : ALL_VALUES) {
            if (state != world.getBlockState(loc.transform(pos))) continue;
            this.compressedData |= loc.getMask();
        }
    }

    public TextureContextPillar(long data) {
        this.data = new ConnectionData(data);
    }

    @Override
    public long getCompressedData() {
        return this.compressedData;
    }

    public ConnectionData getData() {
        return this.data;
    }

    public static class ConnectionData {
        private Connections connections;
        private Map<Direction, Connections> connectionConnections = new EnumMap<Direction, Connections>(Direction.class);

        public ConnectionData(BlockGetter world, BlockPos pos) {
            this.connections = Connections.forPos(world, pos);
            BlockState state = world.getBlockState(pos);
            for (Direction f : Direction.values()) {
                this.connectionConnections.put(f, Connections.forPos(world, state, pos.relative(f)));
            }
        }

        public ConnectionData(long data) {
            this.connections = Connections.forData(data, null);
            for (Direction f : Direction.values()) {
                this.connectionConnections.put(f, Connections.forData(data, f));
            }
        }

        public Connections getConnections(Direction facing) {
            return this.connectionConnections.get(facing);
        }

        public String toString() {
            return "TextureContextPillar.ConnectionData(connections=" + String.valueOf(this.getConnections()) + ", connectionConnections=" + String.valueOf(this.connectionConnections) + ")";
        }

        public Connections getConnections() {
            return this.connections;
        }
    }

    public static class Connections {
        private EnumSet<Direction> connections;

        public boolean connected(Direction facing) {
            return this.connections.contains(facing);
        }

        public boolean connectedAnd(Direction ... facings) {
            for (Direction f : facings) {
                if (this.connected(f)) continue;
                return false;
            }
            return true;
        }

        public boolean connectedOr(Direction ... facings) {
            for (Direction f : facings) {
                if (!this.connected(f)) continue;
                return true;
            }
            return false;
        }

        public static Connections forPos(BlockGetter world, BlockPos pos) {
            BlockState state = world.getBlockState(pos);
            return Connections.forPos(world, state, pos);
        }

        public static Connections forData(long data, Direction offset) {
            EnumSet<Direction> connections = EnumSet.noneOf(Direction.class);
            if (offset == null) {
                for (ConnectionLocations loc : MAIN_VALUES) {
                    if ((data & loc.getMask()) == 0L) continue;
                    connections.add(ConnectionLocations.toFacing(loc));
                }
            } else {
                for (ConnectionLocations loc : OFFSET_VALUES) {
                    Direction facing;
                    if ((data & loc.getMask()) == 0L || (facing = loc.clipOrDestroy(offset)) == null) continue;
                    connections.add(facing);
                }
            }
            return new Connections(connections);
        }

        public static Connections forPos(BlockGetter world, BlockState baseState, BlockPos pos) {
            EnumSet<Direction> connections = EnumSet.noneOf(Direction.class);
            BlockState state = world.getBlockState(pos);
            if (state == baseState) {
                for (Direction f : Direction.values()) {
                    if (world.getBlockState(pos.relative(f)) != baseState) continue;
                    connections.add(f);
                }
            }
            return new Connections(connections);
        }

        public Connections(EnumSet<Direction> connections) {
            this.connections = connections;
        }

        public EnumSet<Direction> getConnections() {
            return this.connections;
        }

        public String toString() {
            return "TextureContextPillar.Connections(connections=" + String.valueOf(this.getConnections()) + ")";
        }
    }
}

