/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.packet;

import java.util.function.Predicate;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.swedz.tesseract.neoforge.packet.PacketContext;

public interface CustomPacket
extends CustomPacketPayload {
    public void handle(PacketContext var1);

    default public void sendToServer() {
        PacketDistributor.sendToServer((CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    default public void sendToClient(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    default public int broadcastToClients(ServerLevel level, Predicate<ServerPlayer> predicate) {
        int sent = 0;
        for (ServerPlayer player : level.players()) {
            if (!predicate.test(player)) continue;
            this.sendToClient(player);
            ++sent;
        }
        return sent;
    }

    default public int broadcastToClients(ServerLevel level) {
        return this.broadcastToClients(level, player -> true);
    }

    default public int broadcastToClients(ServerLevel level, Position origin, double distance) {
        return this.broadcastToClients(level, player -> player.blockPosition().closerToCenterThan(origin, distance));
    }

    default public int broadcastToClients(ServerLevel level, Vec3i origin, double distance) {
        return this.broadcastToClients(level, player -> player.blockPosition().closerThan(origin, distance));
    }

    public CustomPacketPayload.Type<? extends CustomPacket> type();
}

