/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.material;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.swedz.tesseract.neoforge.material.Material;
import net.swedz.tesseract.neoforge.material.part.MaterialPart;
import net.swedz.tesseract.neoforge.material.recipe.MaterialRecipeGroup;
import net.swedz.tesseract.neoforge.registry.holder.BlockHolder;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public abstract class MaterialRegistry {
    public abstract String modId();

    public final ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId(), (String)path);
    }

    public abstract DeferredRegister.Blocks blockRegistry();

    public abstract DeferredRegister<BlockEntityType<?>> blockEntityRegistry();

    public abstract DeferredRegister.Items itemRegistry();

    public abstract void onBlockRegister(BlockHolder var1);

    public abstract void onBlockEntityRegister(BlockEntityType<?> var1);

    public abstract void onItemRegister(ItemHolder var1);

    public final boolean includes(Material material, MaterialPart part) {
        if (!material.has(part)) {
            return false;
        }
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)material.get(part).asItem());
        return this.modId().equals(itemId.getNamespace());
    }

    public final void createRecipesFor(Material material, MaterialRecipeGroup recipeGroup, RecipeOutput recipes) {
        recipeGroup.create(this, material, recipes);
    }

    public final void createRecipesFor(Material material, Function<MaterialRecipeGroup, Optional<MaterialRecipeGroup>> recipeGroupFilter, RecipeOutput recipes) {
        for (MaterialRecipeGroup recipeGroup : material.recipeGroups()) {
            Optional<MaterialRecipeGroup> targetRecipeGroup = recipeGroupFilter.apply(recipeGroup);
            targetRecipeGroup.ifPresent(group -> this.createRecipesFor(material, (MaterialRecipeGroup)group, recipes));
        }
    }

    public final void createRecipesFor(Material material, RecipeOutput recipes) {
        this.createRecipesFor(material, Optional::of, recipes);
    }
}

