/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public final class TagHelper {
    public static TagKey<Item> item(ResourceLocation location) {
        return TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)location);
    }

    public static TagKey<Item> itemCommon(String path) {
        return TagHelper.item(ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    public static List<TagKey<Item>> itemCommonWithChild(String path, String child) {
        return Lists.newArrayList((Object[])new TagKey[]{TagHelper.itemCommon(path), TagHelper.itemCommon("%s/%s".formatted(path, child))});
    }

    public static TagKey<Block> block(ResourceLocation location) {
        return TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)location);
    }

    public static TagKey<Block> blockCommon(String path) {
        return TagHelper.block(ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    public static List<TagKey<Block>> blockCommonWithChild(String path, String child) {
        return Lists.newArrayList((Object[])new TagKey[]{TagHelper.blockCommon(path), TagHelper.blockCommon("%s/%s".formatted(path, child))});
    }

    public static <F, T> TagKey<T> convert(TagKey<F> from, ResourceKey<? extends Registry<T>> to) {
        return TagKey.create(to, (ResourceLocation)from.location());
    }

    public static <F, T> List<TagKey<T>> convert(Collection<TagKey<F>> from, ResourceKey<? extends Registry<T>> to) {
        return from.stream().map(f -> TagHelper.convert(f, to)).toList();
    }

    public static <F, T> TagKey<T> convert(TagKey<F> from, Registry<T> to) {
        return TagHelper.convert(from, to.key());
    }

    public static <F, T> List<TagKey<T>> convert(Collection<TagKey<F>> from, Registry<T> to) {
        return from.stream().map(f -> TagHelper.convert(f, to)).toList();
    }
}

