/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public final class CodecHelper {
    public static <R> Codec<R> forRegistry(Registry<R> registry) {
        return registry.byNameCodec();
    }

    public static <R> StreamCodec<ByteBuf, R> forRegistryStream(Registry<R> registry) {
        return ResourceLocation.STREAM_CODEC.map(arg_0 -> registry.get(arg_0), arg_0 -> registry.getKey(arg_0));
    }

    public static <E extends Enum<E>> Codec<E> forEnum(Class<E> enumClass, Supplier<E[]> values, boolean uppercase) {
        return Codec.STRING.flatXmap(value -> {
            for (Enum entry : (Enum[])values.get()) {
                if (!(uppercase ? entry.toString().toUpperCase(Locale.ROOT).equals(value) : entry.toString().toLowerCase(Locale.ROOT).equals(value))) continue;
                return DataResult.success((Object)entry);
            }
            return DataResult.error(() -> "No value exists for %s".formatted(value));
        }, entry -> DataResult.success((Object)(uppercase ? entry.toString().toUpperCase(Locale.ROOT) : entry.toString().toLowerCase(Locale.ROOT))));
    }

    public static <E extends Enum<E>> Codec<E> forEnum(Class<E> enumClass, Supplier<E[]> values) {
        return CodecHelper.forEnum(enumClass, values, true);
    }

    public static <E extends Enum<E>> Codec<E> forEnum(Class<E> enumClass) {
        return CodecHelper.forEnum(enumClass, enumClass::getEnumConstants);
    }

    public static <E extends Enum<E>> Codec<E> forLowercaseEnum(Class<E> enumClass, Supplier<E[]> values) {
        return CodecHelper.forEnum(enumClass, values, false);
    }

    public static <E extends Enum<E>> Codec<E> forLowercaseEnum(Class<E> enumClass) {
        return CodecHelper.forLowercaseEnum(enumClass, enumClass::getEnumConstants);
    }

    public static <E extends Enum<E>> StreamCodec<ByteBuf, E> forEnumStream(Class<E> enumClass, Supplier<E[]> values, boolean uppercase) {
        return ByteBufCodecs.STRING_UTF8.map(value -> {
            for (Enum entry : (Enum[])values.get()) {
                if (!(uppercase ? entry.toString().toUpperCase(Locale.ROOT).equals(value) : entry.toString().toLowerCase(Locale.ROOT).equals(value))) continue;
                return entry;
            }
            throw new NoSuchElementException("No value exists for %s".formatted(value));
        }, entry -> uppercase ? entry.toString().toUpperCase(Locale.ROOT) : entry.toString().toLowerCase(Locale.ROOT));
    }

    public static <E extends Enum<E>> StreamCodec<ByteBuf, E> forEnumStream(Class<E> enumClass, Supplier<E[]> values) {
        return CodecHelper.forEnumStream(enumClass, values, true);
    }

    public static <E extends Enum<E>> StreamCodec<ByteBuf, E> forEnumStream(Class<E> enumClass) {
        return CodecHelper.forEnumStream(enumClass, enumClass::getEnumConstants);
    }

    public static <E extends Enum<E>> StreamCodec<ByteBuf, E> forLowercaseEnumStream(Class<E> enumClass, Supplier<E[]> values) {
        return CodecHelper.forEnumStream(enumClass, values, false);
    }

    public static <E extends Enum<E>> StreamCodec<ByteBuf, E> forLowercaseEnumStream(Class<E> enumClass) {
        return CodecHelper.forLowercaseEnumStream(enumClass, enumClass::getEnumConstants);
    }

    public static Codec<Long> longRange(long minInclusive, long maxInclusive) {
        Function checker = Codec.checkRange((Number)minInclusive, (Number)maxInclusive);
        return Codec.LONG.flatXmap(checker, checker);
    }
}

