/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.saved;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class BookProgressions
extends SavedData {
    private static final String TAG_PROGRESSION_COUNT = "progression_count";
    private static final String TAG_PROGRESSION = "progression";
    private static final String TAG_ID = "id";
    private static final String TAG_UNLOCKED_COUNT = "unlocked_count";
    private static final String TAG_UNLOCKED = "unlocked";
    private final Map<UUID, Set<ResourceLocation>> progressions = new HashMap<UUID, Set<ResourceLocation>>();

    public Map<UUID, Set<ResourceLocation>> getProgressions() {
        return this.progressions;
    }

    public static SavedData.Factory<BookProgressions> factory(ServerLevel serverLevel) {
        return new SavedData.Factory(BookProgressions::new, (compoundTag, lookup) -> BookProgressions.load(serverLevel, compoundTag), null);
    }

    public static BookProgressions load(ServerLevel serverLevel, CompoundTag compoundTag) {
        BookProgressions progression = new BookProgressions();
        int progressionCount = compoundTag.getInt(TAG_PROGRESSION_COUNT);
        if (progressionCount > 0) {
            for (int i = 0; i < progressionCount; ++i) {
                if (!compoundTag.contains(TAG_PROGRESSION + i, 10)) continue;
                CompoundTag progressionTag = compoundTag.getCompound(TAG_PROGRESSION + i);
                UUID id = progressionTag.getUUID(TAG_ID);
                HashSet<ResourceLocation> allUnlocked = new HashSet<ResourceLocation>();
                int unlockedCount = progressionTag.getInt(TAG_UNLOCKED_COUNT);
                if (unlockedCount > 0) {
                    for (int j = 0; j < unlockedCount; ++j) {
                        ResourceLocation unlocked = ResourceLocation.parse((String)progressionTag.getString(TAG_UNLOCKED + j));
                        allUnlocked.add(unlocked);
                    }
                }
                progression.progressions.put(id, allUnlocked);
            }
        }
        return progression;
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        compoundTag.putInt(TAG_PROGRESSION_COUNT, this.progressions.size());
        int i = 0;
        for (Map.Entry<UUID, Set<ResourceLocation>> entry : this.progressions.entrySet()) {
            CompoundTag progressionTag = new CompoundTag();
            progressionTag.putUUID(TAG_ID, entry.getKey());
            progressionTag.putInt(TAG_UNLOCKED_COUNT, entry.getValue().size());
            List list = entry.getValue().stream().sorted().toList();
            for (int j = 0; j < list.size(); ++j) {
                progressionTag.putString(TAG_UNLOCKED + j, ((ResourceLocation)list.get(j)).toString());
            }
            compoundTag.put(TAG_PROGRESSION + i, (Tag)progressionTag);
            ++i;
        }
        return compoundTag;
    }
}

