/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature.tree.foliage;

import cn.leolezury.eternalstarlight.common.registry.ESTreePlacers;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class SpheroidFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<SpheroidFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> SpheroidFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, SpheroidFoliagePlacer::new));

    public SpheroidFoliagePlacer(IntProvider horizontalRadius, IntProvider yOffset) {
        super(horizontalRadius, yOffset);
    }

    protected FoliagePlacerType<SpheroidFoliagePlacer> type() {
        return ESTreePlacers.FOLIAGE_SPHEROID.get();
    }

    protected static void placeFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration configuration, BlockPos pos) {
        if (SpheroidFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)configuration, (BlockPos)pos)) {
            for (Direction direction : Direction.values()) {
                if (random.nextInt(5) != 0) continue;
                SpheroidFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)configuration, (BlockPos)pos.relative(direction));
            }
        }
    }

    public static void placeSpheroidFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, TreeConfiguration configuration, RandomSource random, BlockPos centerPos, float xzRadius, float yRadius) {
        int x = 0;
        while ((float)x <= xzRadius) {
            int z = 0;
            while ((float)z <= xzRadius) {
                int y = 0;
                while ((float)y <= yRadius) {
                    if (ESMathUtil.isPointInEllipsoid(x, y, z, xzRadius, yRadius, xzRadius)) {
                        SpheroidFoliagePlacer.placeFoliage(level, setter, random, configuration, centerPos.offset(x, y, z));
                        SpheroidFoliagePlacer.placeFoliage(level, setter, random, configuration, centerPos.offset(x, -y, z));
                        SpheroidFoliagePlacer.placeFoliage(level, setter, random, configuration, centerPos.offset(-x, y, z));
                        SpheroidFoliagePlacer.placeFoliage(level, setter, random, configuration, centerPos.offset(-x, -y, z));
                        SpheroidFoliagePlacer.placeFoliage(level, setter, random, configuration, centerPos.offset(x, y, -z));
                        SpheroidFoliagePlacer.placeFoliage(level, setter, random, configuration, centerPos.offset(x, -y, -z));
                        SpheroidFoliagePlacer.placeFoliage(level, setter, random, configuration, centerPos.offset(-x, y, -z));
                        SpheroidFoliagePlacer.placeFoliage(level, setter, random, configuration, centerPos.offset(-x, -y, -z));
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
    }

    protected void createFoliage(LevelSimulatedReader levelReader, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration configuration, int trunkHeight, FoliagePlacer.FoliageAttachment foliage, int foliageHeight, int radius, int offset) {
        BlockPos center = foliage.pos().above(offset);
        SpheroidFoliagePlacer.placeSpheroidFoliage(levelReader, setter, configuration, random, center, foliage.radiusOffset() + this.radius.sample(random), (float)foliage.radiusOffset() + 1.5f + (float)random.nextInt(2));
    }

    public int foliageHeight(RandomSource random, int i, TreeConfiguration treeConfiguration) {
        return 0;
    }

    protected boolean shouldSkipLocation(RandomSource random, int i0, int i1, int i2, int i3, boolean bool) {
        return false;
    }
}

