/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature;

import cn.leolezury.eternalstarlight.common.block.DirectionalBudBlock;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class VelvetumossFeature
extends Feature<Configuration> {
    public VelvetumossFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        Configuration config = (Configuration)context.config();
        BlockPos.MutableBlockPos stonePos = new BlockPos.MutableBlockPos();
        for (int x = -3; x <= 3; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    BlockPos growPos;
                    if (!ESMathUtil.isPointInEllipsoid(x, y, z, 3 + random.nextInt(3) - 1, 3 + random.nextInt(3) - 1, 3 + random.nextInt(3) - 1)) continue;
                    stonePos.setWithOffset((Vec3i)pos, x, y, z);
                    if (!level.getBlockState((BlockPos)stonePos).is(ESTags.Blocks.ABYSSLATES)) continue;
                    if (stonePos.distToCenterSqr((Position)stonePos.getCenter()) < 4.0 && Arrays.stream(Direction.values()).anyMatch(direction -> level.getBlockState(stonePos.relative(direction)).is(Blocks.WATER))) {
                        this.setBlock((LevelWriter)level, (BlockPos)stonePos, config.moss().defaultBlockState());
                    }
                    for (Direction direction2 : Direction.values()) {
                        BlockPos growPos2 = stonePos.relative(direction2);
                        if (!level.getBlockState(growPos2).is(Blocks.WATER) || random.nextInt(3) != 0) continue;
                        this.setBlock((LevelWriter)level, growPos2, (BlockState)((BlockState)config.villi().defaultBlockState().setValue((Property)DirectionalBudBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)DirectionalBudBlock.FACING, (Comparable)direction2));
                    }
                    if (!config.flower().isPresent() || random.nextInt(10) != 0 || !level.getBlockState(growPos = stonePos.relative(Direction.UP)).is(Blocks.WATER)) continue;
                    this.setBlock((LevelWriter)level, growPos, (BlockState)config.flower().get().defaultBlockState().setValue((Property)DirectionalBudBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
                }
            }
        }
        return true;
    }

    public record Configuration(Block moss, Block villi, Optional<Block> flower) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("moss").forGetter(Configuration::moss), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("villi").forGetter(Configuration::villi), (App)BuiltInRegistries.BLOCK.byNameCodec().optionalFieldOf("flower").forGetter(Configuration::flower)).apply((Applicative)instance, Configuration::new));
    }
}

