/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.vfx;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.vfx.ManaCrystalParticleVfx;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import cn.leolezury.eternalstarlight.common.vfx.SyncedVfxType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class VfxRegistry {
    private static final Map<ResourceLocation, SyncedVfxType> EFFECTS = new HashMap<ResourceLocation, SyncedVfxType>();
    public static final SyncedVfxType SCREEN_SHAKE = VfxRegistry.register("screen_shake", (SyncedVfxType)new ScreenShakeVfx());
    public static final SyncedVfxType MANA_CRYSTAL_PARTICLE = VfxRegistry.register("mana_crystal_particle", (SyncedVfxType)new ManaCrystalParticleVfx());

    private static SyncedVfxType register(String location, SyncedVfxType type) {
        return VfxRegistry.register(EternalStarlight.id(location), type);
    }

    public static SyncedVfxType register(ResourceLocation location, SyncedVfxType type) {
        EFFECTS.put(location, type);
        return type;
    }

    public static Optional<SyncedVfxType> get(ResourceLocation location) {
        return Optional.ofNullable(EFFECTS.get(location));
    }

    public static ResourceLocation getKey(SyncedVfxType type) {
        for (Map.Entry<ResourceLocation, SyncedVfxType> entry : EFFECTS.entrySet()) {
            if (entry.getValue() != type) continue;
            return entry.getKey();
        }
        return ResourceLocation.withDefaultNamespace((String)"unregistered");
    }
}

