/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.network;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.util.ESMiscUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record UpdateStarlightStoryPacket(Set<ResourceLocation> oldUnlocked, Set<ResourceLocation> unlocked) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateStarlightStoryPacket> TYPE = new CustomPacketPayload.Type(EternalStarlight.id("update_starlight_story"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateStarlightStoryPacket> STREAM_CODEC = StreamCodec.ofMember(UpdateStarlightStoryPacket::write, UpdateStarlightStoryPacket::read);

    public static UpdateStarlightStoryPacket read(FriendlyByteBuf buf) {
        int oldSize = buf.readInt();
        HashSet<ResourceLocation> oldUnlocked = new HashSet<ResourceLocation>();
        for (int i = 0; i < oldSize; ++i) {
            oldUnlocked.add(ResourceLocation.parse((String)buf.readUtf()));
        }
        int size = buf.readInt();
        HashSet<ResourceLocation> unlocked = new HashSet<ResourceLocation>();
        for (int i = 0; i < size; ++i) {
            unlocked.add(ResourceLocation.parse((String)buf.readUtf()));
        }
        return new UpdateStarlightStoryPacket(oldUnlocked, unlocked);
    }

    public static void write(UpdateStarlightStoryPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.oldUnlocked().size());
        for (ResourceLocation resourceLocation : packet.oldUnlocked()) {
            buf.writeUtf(resourceLocation.toString());
        }
        buf.writeInt(packet.unlocked().size());
        for (ResourceLocation resourceLocation : packet.unlocked()) {
            buf.writeUtf(resourceLocation.toString());
        }
    }

    public static void handle(UpdateStarlightStoryPacket packet, Player player) {
        ESMiscUtil.runWhenOnClient(() -> () -> EternalStarlight.getClientHelper().handleUpdateStarlightStory(packet));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

