/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin.client;

import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.item.combat.SeedsLauncherItem;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    @Nullable
    public ClientLevel level;

    @Inject(method={"getSituationalMusic()Lnet/minecraft/sounds/Music;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getSituationalMusic(CallbackInfoReturnable<Music> cir) {
        Holder biomeHolder;
        if (this.player != null && this.player.level().dimension().location().equals((Object)ESDimensions.STARLIGHT_KEY.location()) && (cir.getReturnValue() == Musics.GAME || cir.getReturnValue() == Musics.CREATIVE || cir.getReturnValue() == Musics.UNDER_WATER) && (biomeHolder = this.player.level().getBiome(new BlockPos(this.player.getBlockX(), this.player.getBlockY(), this.player.getBlockZ()))).isBound()) {
            cir.setReturnValue((Object)((Biome)biomeHolder.value()).getBackgroundMusic().orElse(Musics.GAME));
        }
    }

    @WrapOperation(method={"startUseItem()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ItemInHandRenderer;itemUsed(Lnet/minecraft/world/InteractionHand;)V")})
    private void itemUsed(ItemInHandRenderer instance, InteractionHand hand, Operation<Void> original) {
        if (this.player == null || !(this.player.getItemInHand(hand).getItem() instanceof SeedsLauncherItem)) {
            original.call(new Object[]{instance, hand});
        } else {
            ClientHandlers.oldSeedsLauncherAnimTicks = 5;
            ClientHandlers.seedsLauncherAnimTicks = 5;
        }
    }
}

