/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.misc;

import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ESPainting
extends Painting {
    private static final String TAG_ITEM = "item";
    private ItemStack item = ESItems.STARLIT_PAINTING.get().getDefaultInstance();

    public ESPainting(Level level, BlockPos blockPos) {
        super(ESEntities.PAINTING.get(), level);
        this.pos = blockPos;
        this.direction = Direction.SOUTH;
    }

    public ESPainting(EntityType<? extends ESPainting> type, Level level) {
        super(type, level);
    }

    public static Optional<ESPainting> createPainting(Level level, ItemStack item, BlockPos blockPos, Direction direction) {
        ESPainting painting = new ESPainting(level, blockPos);
        ArrayList<Holder> list = new ArrayList<Holder>();
        Iterable placeable = level.registryAccess().registryOrThrow(Registries.PAINTING_VARIANT).getTagOrEmpty(ESTags.PaintingVariants.PLACEABLE);
        placeable.forEach(list::add);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        painting.setDirection(direction);
        list.removeIf(holder -> {
            painting.setVariant((Holder)holder);
            return !painting.survives();
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        int i = list.stream().mapToInt(holder -> ((PaintingVariant)holder.value()).area()).max().orElse(0);
        list.removeIf(holder -> ((PaintingVariant)holder.value()).area() < i);
        Optional optional = Util.getRandomSafe(list, (RandomSource)painting.getRandom());
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        painting.setVariant((Holder)optional.get());
        painting.setDirection(direction);
        painting.setItem(item);
        return Optional.of(painting);
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public void dropItem(@Nullable Entity entity) {
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            Player player;
            this.playSound(SoundEvents.PAINTING_BREAK, 1.0f, 1.0f);
            if (entity instanceof Player && (player = (Player)entity).hasInfiniteMaterials()) {
                return;
            }
            this.spawnAtLocation(this.item);
        }
    }

    public ItemStack getPickResult() {
        return this.item.copy();
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.put(TAG_ITEM, this.item.save((HolderLookup.Provider)this.registryAccess()));
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        if (compoundTag.contains(TAG_ITEM, 10)) {
            this.setItem(ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compoundTag.getCompound(TAG_ITEM)).orElse(ESItems.STARLIT_PAINTING.get().getDefaultInstance()));
        } else {
            this.setItem(ESItems.STARLIT_PAINTING.get().getDefaultInstance());
        }
    }
}

