/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.interfaces.RayAttackUser;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESServerBossEvent;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosityBitePhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosityDigPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosityEmergePhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrositySneakPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrositySoulPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrositySporePhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosityStunPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosityThornPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosityToxicBreathPhase;
import cn.leolezury.eternalstarlight.common.entity.living.goal.LookAtTargetGoal;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorManager;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ESSmokeParticleOptions;
import cn.leolezury.eternalstarlight.common.particle.RingExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESMobEffects;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESBookUtil;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.List;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LunarMonstrosity
extends ESBoss
implements RayAttackUser {
    private final ESServerBossEvent bossEvent = new ESServerBossEvent(this, this.getUUID(), BossEvent.BossBarColor.PURPLE, true);
    private final BehaviorManager<LunarMonstrosity> behaviorManager = new BehaviorManager<LunarMonstrosity>(this, List.of(new LunarMonstrosityToxicBreathPhase(), new LunarMonstrositySporePhase(), new LunarMonstrosityThornPhase(), new LunarMonstrosityBitePhase(), new LunarMonstrosityDigPhase(), new LunarMonstrositySneakPhase(), new LunarMonstrosityEmergePhase(), new LunarMonstrositySoulPhase(), new LunarMonstrosityStunPhase()));
    public AnimationState toxicBreathAnimationState = new AnimationState();
    public AnimationState sporeAnimationState = new AnimationState();
    public AnimationState thornAnimationState = new AnimationState();
    public AnimationState biteAnimationState = new AnimationState();
    public AnimationState digAnimationState = new AnimationState();
    public AnimationState sneakAnimationState = new AnimationState();
    public AnimationState emergeAnimationState = new AnimationState();
    public AnimationState switchPhaseAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public Vec3 headPos = Vec3.ZERO;

    public LunarMonstrosity(EntityType<? extends LunarMonstrosity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.bossEvent.setId(this.getUUID());
    }

    public void startSeenByPlayer(ServerPlayer serverPlayer) {
        super.startSeenByPlayer(serverPlayer);
        this.bossEvent.addPlayer(serverPlayer);
        ESBookUtil.unlock(serverPlayer, EternalStarlight.id("lunar_monstrosity_seen"));
    }

    public void stopSeenByPlayer(ServerPlayer serverPlayer) {
        super.stopSeenByPlayer(serverPlayer);
        this.bossEvent.removePlayer(serverPlayer);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LunarMonstrosityMeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(2, (Goal)new MonstrosityLookAtTargetGoal());
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{LunarMonstrosity.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    @Override
    public boolean isRayFollowingHeadRotation() {
        return false;
    }

    @Override
    public Vec3 getRayRotationTarget() {
        return this.getTarget() == null ? this.position().add((double)(this.getBbWidth() * (this.getRandom().nextFloat() - 0.5f)), (double)(this.getBbHeight() * this.getRandom().nextFloat()), (double)(this.getBbWidth() * (this.getRandom().nextFloat() - 0.5f))) : this.getTarget().position().add((double)(this.getTarget().getBbWidth() * (this.getRandom().nextFloat() - 0.5f)), (double)(this.getTarget().getBbHeight() * this.getRandom().nextFloat()), (double)(this.getTarget().getBbWidth() * (this.getRandom().nextFloat() - 0.5f)));
    }

    @Override
    public void updateRayEnd(Vec3 endPos) {
        this.setXRot(-ESMathUtil.positionToPitch(this.position(), endPos));
        this.setYHeadRot(ESMathUtil.positionToYaw(this.position(), endPos) - 90.0f);
        this.setYRot(ESMathUtil.positionToYaw(this.position(), endPos) - 90.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LunarMonstrosity.createMonsterAttributes().add(Attributes.MAX_HEALTH, ESConfig.INSTANCE.mobsConfig.lunarMonstrosity.maxHealth()).add(Attributes.ARMOR, ESConfig.INSTANCE.mobsConfig.lunarMonstrosity.armor()).add(Attributes.ATTACK_DAMAGE, 5.0 * ESConfig.INSTANCE.mobsConfig.lunarMonstrosity.attackDamageScale()).add(Attributes.FOLLOW_RANGE, ESConfig.INSTANCE.mobsConfig.lunarMonstrosity.followRange()).add(Attributes.MOVEMENT_SPEED, (double)0.35f).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    protected void tickDeath() {
        if (this.deathTime == 0) {
            this.stopAllAnimStates();
            this.deathAnimationState.start(this.tickCount);
            this.setBehaviorState(0);
        }
        ++this.deathTime;
        if (this.deathTime == 75 && !this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void stopAllAnimStates() {
        this.toxicBreathAnimationState.stop();
        this.sporeAnimationState.stop();
        this.thornAnimationState.stop();
        this.biteAnimationState.stop();
        this.digAnimationState.stop();
        this.sneakAnimationState.stop();
        this.emergeAnimationState.stop();
        this.switchPhaseAnimationState.stop();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> accessor) {
        if (accessor.equals((Object)BEHAVIOR_STATE) && this.getBehaviorState() != 0) {
            this.stopAllAnimStates();
            switch (this.getBehaviorState()) {
                case 1: {
                    this.toxicBreathAnimationState.start(this.tickCount);
                    break;
                }
                case 2: {
                    this.sporeAnimationState.start(this.tickCount);
                    break;
                }
                case 3: {
                    this.thornAnimationState.start(this.tickCount);
                    break;
                }
                case 4: {
                    this.biteAnimationState.start(this.tickCount);
                    break;
                }
                case 5: {
                    this.digAnimationState.start(this.tickCount);
                    break;
                }
                case 6: {
                    this.sneakAnimationState.start(this.tickCount);
                    break;
                }
                case 7: {
                    this.emergeAnimationState.start(this.tickCount);
                    break;
                }
                case 8: {
                    this.switchPhaseAnimationState.start(this.tickCount);
                }
            }
        }
        super.onSyncedDataUpdated(accessor);
    }

    protected void blockedByShield(LivingEntity blocker) {
        if (this.getBehaviorState() == 4 && blocker == this.getTarget()) {
            this.setBehaviorState(-1);
        }
        super.blockedByShield(blocker);
    }

    public boolean doHurtTarget(Entity target) {
        if (this.getBehaviorState() == 6) {
            this.setBehaviorState(7);
            this.setBehaviorTicks(0);
        }
        return super.doHurtTarget(target);
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurt(source, amount);
        }
        if (this.getBehaviorState() == 6 || source.getEntity() != null && source.getEntity().getType().is(ESTags.EntityTypes.LUNAR_MONSTROSITY_ALLYS)) {
            return false;
        }
        if (this.getPhase() == 0 && (double)(this.getHealth() / this.getMaxHealth()) < 0.5) {
            this.setPhase(1);
            this.setBehaviorState(8);
            this.setBehaviorTicks(0);
            return super.hurt(source, amount / 2.0f);
        }
        if (source.getEntity() != null && this.getTarget() != null && this.getBehaviorState() == 4 && source.getEntity() == this.getTarget() && amount >= 6.0f) {
            this.setBehaviorState(-1);
            this.setBehaviorTicks(0);
        }
        if (this.isOnFire() || this.hasEffect(ESMobEffects.STARFIRE.asHolder()) || this.getBehaviorState() == -1) {
            return super.hurt(source, amount * 1.2f);
        }
        return super.hurt(source, Math.min(1.0f, amount));
    }

    public boolean addEffect(MobEffectInstance instance, @Nullable Entity entity) {
        if (instance.getEffect().is(MobEffects.POISON)) {
            return false;
        }
        return super.addEffect(instance, entity);
    }

    public boolean isAlliedTo(Entity entity) {
        return super.isAlliedTo(entity) || entity.getType().is(ESTags.EntityTypes.LUNAR_MONSTROSITY_ALLYS);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(ESTags.Items.LUNAR_MONSTROSITY_IGNITERS)) {
            SoundEvent soundEvent = itemStack.isDamageableItem() ? SoundEvents.FLINTANDSTEEL_USE : SoundEvents.FIRECHARGE_USE;
            this.level().playSound(player, this.getX(), this.getY(), this.getZ(), soundEvent, this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
            if (!this.level().isClientSide) {
                this.setRemainingFireTicks(Math.max(this.getRemainingFireTicks(), this.getPhase() == 0 ? 100 : 20));
                if (!itemStack.isDamageableItem()) {
                    itemStack.consume(1, (LivingEntity)player);
                } else {
                    itemStack.hurtAndBreak(1, (LivingEntity)player, LunarMonstrosity.getSlotForHand((InteractionHand)hand));
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.getBehaviorState() == 6 ? super.getDefaultDimensions(pose).scale(0.1f) : super.getDefaultDimensions(pose);
    }

    public boolean displayFireAnimation() {
        return this.getBehaviorState() != 6 && super.displayFireAnimation();
    }

    @Override
    public SoundEvent getBossMusic() {
        return ESSoundEvents.MUSIC_BOSS_LUNAR_MONSTROSITY.get();
    }

    public boolean canBite() {
        LivingEntity target = this.getTarget();
        if (target == null) {
            return false;
        }
        for (LivingEntity livingEntity : this.level().getNearbyEntities(LivingEntity.class, TargetingConditions.DEFAULT, (LivingEntity)this, this.getBoundingBox().inflate(3.0))) {
            Vec3 vec3 = livingEntity.position().vectorTo(this.position()).normalize();
            vec3 = new Vec3(vec3.x, 0.0, vec3.z);
            if (!(vec3.dot(this.getViewVector(1.0f)) < 0.0) || target != livingEntity) continue;
            return true;
        }
        return false;
    }

    public void doBiteDamage(float damage) {
        for (LivingEntity livingEntity : this.level().getNearbyEntities(LivingEntity.class, TargetingConditions.DEFAULT, (LivingEntity)this, this.getBoundingBox().inflate(3.0))) {
            Vec3 vec3 = livingEntity.position().vectorTo(this.position()).normalize();
            vec3 = new Vec3(vec3.x, 0.0, vec3.z);
            if (!(vec3.dot(this.getViewVector(1.0f)) < 0.0)) continue;
            livingEntity.hurt(ESDamageTypes.getEntityDamageSource(this.level(), ESDamageTypes.BITE, (Entity)this), damage * (float)ESConfig.INSTANCE.mobsConfig.lunarMonstrosity.attackDamageScale());
        }
    }

    public void knockbackNearbyEntities(float radius, float strength, boolean damage) {
        for (LivingEntity living : this.level().getNearbyEntities(LivingEntity.class, TargetingConditions.DEFAULT, (LivingEntity)this, this.getBoundingBox().inflate((double)radius, 0.0, (double)radius))) {
            if (living.getType().is(ESTags.EntityTypes.LUNAR_MONSTROSITY_ALLYS)) continue;
            Vec3 motion = living.position().subtract(this.position()).normalize().scale((double)strength);
            living.hurtMarked = true;
            living.setDeltaMovement(living.getDeltaMovement().add(motion));
            if (!damage) continue;
            living.hurt(this.damageSources().mobAttack((LivingEntity)this), strength * 3.0f * (float)ESConfig.INSTANCE.mobsConfig.lunarMonstrosity.attackDamageScale());
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(RingExplosionParticleOptions.LUNAR, this.getX(), this.getY(), this.getZ(), 0.0, 0.2, 0.0));
        }
    }

    public boolean ignoreExplosion(Explosion explosion) {
        LivingEntity cause = explosion.getIndirectSourceEntity();
        return cause != null && cause.getType().is(ESTags.EntityTypes.LUNAR_MONSTROSITY_ALLYS);
    }

    public void aiStep() {
        super.aiStep();
        this.bossEvent.update();
        this.refreshDimensions();
        if (!this.level().isClientSide) {
            if (this.getTarget() != null && !this.getTarget().isAlive()) {
                this.setTarget(null);
            }
            if (!this.isNoAi() && this.isAlive()) {
                this.behaviorManager.tick();
            }
            if (this.getBehaviorState() != 6) {
                this.getNavigation().stop();
            }
        } else {
            this.level().addParticle((ParticleOptions)ESSmokeParticleOptions.LUNAR_SHORT, this.getX() + (this.getRandom().nextDouble() - 0.5) * 3.0, this.getY() + 1.0 + (this.getRandom().nextDouble() - 0.5) * 3.0, this.getZ() + (this.getRandom().nextDouble() - 0.5) * 3.0, 0.0, 0.0, 0.0);
            if (this.deathTime <= 0) {
                if (this.getBehaviorState() == 6) {
                    RandomSource randomsource = this.getRandom();
                    BlockState blockstate = this.getBlockStateOn();
                    if (blockstate.getRenderShape() != RenderShape.INVISIBLE) {
                        for (int i = 0; i < 30; ++i) {
                            double d0 = this.getX() + (double)Mth.randomBetween((RandomSource)randomsource, (float)-0.7f, (float)0.7f);
                            double d1 = this.getY();
                            double d2 = this.getZ() + (double)Mth.randomBetween((RandomSource)randomsource, (float)-0.7f, (float)0.7f);
                            this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate), d0, d1, d2, 0.0, 0.0, 0.0);
                        }
                    }
                } else if (this.getBehaviorState() == -1) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.CRIT, this.headPos.x + this.getRandom().nextDouble() - 0.5, this.headPos.y, this.headPos.z + this.getRandom().nextDouble() - 0.5, this.getRandom().nextDouble() / 10.0, 0.8, this.getRandom().nextDouble() / 10.0);
                }
            }
        }
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return ESSoundEvents.LUNAR_MONSTROSITY_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ESSoundEvents.LUNAR_MONSTROSITY_DEATH.get();
    }

    private static class LunarMonstrosityMeleeAttackGoal
    extends MeleeAttackGoal {
        private LunarMonstrosityMeleeAttackGoal(PathfinderMob mob, double speed, boolean followingTargetEvenIfNotSeen) {
            super(mob, speed, followingTargetEvenIfNotSeen);
        }

        public boolean canUse() {
            boolean canUse = true;
            PathfinderMob pathfinderMob = this.mob;
            if (pathfinderMob instanceof LunarMonstrosity) {
                LunarMonstrosity boss = (LunarMonstrosity)pathfinderMob;
                canUse = boss.getBehaviorState() == 6;
            }
            return super.canUse() && canUse;
        }

        public boolean canContinueToUse() {
            boolean canUse = true;
            PathfinderMob pathfinderMob = this.mob;
            if (pathfinderMob instanceof LunarMonstrosity) {
                LunarMonstrosity boss = (LunarMonstrosity)pathfinderMob;
                canUse = boss.getBehaviorState() == 6;
            }
            return super.canContinueToUse() && canUse;
        }
    }

    private class MonstrosityLookAtTargetGoal
    extends LookAtTargetGoal {
        public MonstrosityLookAtTargetGoal() {
            super((Mob)LunarMonstrosity.this);
        }

        @Override
        public void tick() {
            if (LunarMonstrosity.this.getBehaviorState() != 1) {
                super.tick();
            }
        }
    }
}

