/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper;

import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.TheGatekeeper;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorPhase;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class GatekeeperDashPhase
extends BehaviorPhase<TheGatekeeper> {
    public static final int ID = 3;
    private boolean attacked = false;

    public GatekeeperDashPhase() {
        super(3, 2, 25, 80);
    }

    @Override
    public boolean canStart(TheGatekeeper entity, boolean cooldownOver) {
        return cooldownOver && this.canReachTarget(entity, 10.0) && !this.canReachTarget(entity, 3.0);
    }

    @Override
    public void onStart(TheGatekeeper entity) {
        this.attacked = false;
    }

    @Override
    public void tick(TheGatekeeper entity) {
        entity.getNavigation().stop();
        LivingEntity target = entity.getTarget();
        if (!this.attacked && entity.getBehaviorTicks() > 8 && this.canReachTarget(entity, 2.0) && this.isFacingTarget(entity, 40.0f, entity.getFixedYRot() + 90.0f)) {
            this.performMeleeAttack(entity, 2.0);
            this.attacked = true;
        }
        if (target != null) {
            if (entity.getBehaviorTicks() == 8) {
                entity.hurtMarked = true;
                entity.setDeltaMovement(entity.getDeltaMovement().add(target.position().subtract(entity.position()).normalize().scale(3.0)));
                float yRot = ESMathUtil.positionToYaw(entity.position(), target.position()) - 90.0f;
                entity.setFixedYRot(yRot);
                entity.getNavigation().stop();
            }
            entity.getLookControl().setLookAt((Entity)target, 360.0f, 360.0f);
        }
    }

    @Override
    public boolean canContinue(TheGatekeeper entity) {
        return true;
    }

    @Override
    public void onStop(TheGatekeeper entity) {
    }
}

