/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.attack.ray;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.attack.ray.RayAttack;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosity;
import cn.leolezury.eternalstarlight.common.particle.ESSmokeParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LunarMonstrosityBreath
extends RayAttack {
    public LunarMonstrosityBreath(EntityType<? extends LunarMonstrosityBreath> type, Level level) {
        super(type, level);
    }

    public LunarMonstrosityBreath(EntityType<? extends LunarMonstrosityBreath> type, Level world, LivingEntity caster, double x, double y, double z, float yaw, float pitch) {
        super(type, world, caster, x, y, z, yaw, pitch);
    }

    @Override
    public float getAttackDamage() {
        return 3.0f * (float)ESConfig.INSTANCE.mobsConfig.lunarMonstrosity.attackDamageScale();
    }

    @Override
    public float getRotationSpeed() {
        return 1.4f;
    }

    @Override
    public void doHurtTarget(LivingEntity target) {
        this.getCaster().ifPresent(caster -> {
            if (caster != target && target.hurt(ESDamageTypes.getIndirectEntityDamageSource(this.level(), ESDamageTypes.POISON, this, caster), this.getAttackDamage()) && !target.hasEffect(MobEffects.POISON)) {
                target.addEffect(new MobEffectInstance(MobEffects.POISON, 60));
            }
        });
    }

    @Override
    public void updatePosition() {
        this.getCaster().ifPresentOrElse(caster -> {
            if (caster instanceof LunarMonstrosity) {
                LunarMonstrosity monstrosity = (LunarMonstrosity)caster;
                this.setPos(caster.position().add(0.0, (double)caster.getBbHeight(), 0.0));
                if (monstrosity.getBehaviorState() != 1 || monstrosity.isDeadOrDying()) {
                    this.discard();
                }
            }
        }, () -> ((LunarMonstrosityBreath)this).discard());
    }

    @Override
    public void addEndParticles(Vec3 endPos) {
        Vec3 vec3;
        Entity entity;
        if (this.getCaster().isPresent() && (entity = this.getCaster().get()) instanceof LunarMonstrosity) {
            LunarMonstrosity monstrosity = (LunarMonstrosity)entity;
            vec3 = monstrosity.headPos;
        } else {
            vec3 = this.position();
        }
        Vec3 from = vec3;
        Vec3 delta = endPos.subtract(from);
        for (int i = 0; i < 10; ++i) {
            double dx = delta.x();
            double dy = delta.y();
            double dz = delta.z();
            double spread = 5.0 + (double)this.random.nextFloat() * 2.5;
            double velocity = 3.0 + (double)this.random.nextFloat() * 0.15;
            dx += this.random.nextGaussian() * 0.0075 * spread;
            dy += this.random.nextGaussian() * 0.0075 * spread;
            dz += this.random.nextGaussian() * 0.0075 * spread;
            endPos.add((double)((this.random.nextFloat() - 0.5f) * 2.5f), (double)((this.random.nextFloat() - 0.5f) * 2.5f), (double)((this.random.nextFloat() - 0.5f) * 2.5f));
            this.level().addParticle((ParticleOptions)ESSmokeParticleOptions.LUNAR_BREATH, from.x, from.y, from.z, dx *= velocity, dy *= velocity, dz *= velocity);
        }
    }
}

