/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.data;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.enchantment.effects.Freeze;
import cn.leolezury.eternalstarlight.common.enchantment.effects.PushTowardsEntity;
import cn.leolezury.eternalstarlight.common.particle.ESSmokeParticleOptions;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESMobEffects;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.AddValue;
import net.minecraft.world.item.enchantment.effects.ApplyMobEffect;
import net.minecraft.world.item.enchantment.effects.Ignite;
import net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;

public class ESEnchantments {
    public static final ResourceKey<Enchantment> POISONING = ESEnchantments.create("poisoning");
    public static final ResourceKey<Enchantment> FEARLESS = ESEnchantments.create("fearless");
    public static final ResourceKey<Enchantment> SOUL_SNATCHER = ESEnchantments.create("soul_snatcher");
    public static final ResourceKey<Enchantment> TEARING = ESEnchantments.create("tearing");
    public static final ResourceKey<Enchantment> OVERHEAT = ESEnchantments.create("overheat");
    public static final ResourceKey<Enchantment> GLACIAL_SOWING = ESEnchantments.create("glacial_sowing");
    public static final ResourceKey<Enchantment> FERTILE = ESEnchantments.create("fertile");

    public static void bootstrap(BootstrapContext<Enchantment> context) {
        HolderGetter items = context.lookup(Registries.ITEM);
        HolderGetter enchantments = context.lookup(Registries.ENCHANTMENT);
        context.register(POISONING, (Object)Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.ARMOR_ENCHANTABLE), (int)10, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)11), (Enchantment.Cost)Enchantment.dynamicCost((int)12, (int)11), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ARMOR})).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.VICTIM, EnchantmentTarget.ATTACKER, (Object)new ApplyMobEffect((HolderSet)HolderSet.direct((Holder[])new Holder[]{MobEffects.POISON}), (LevelBasedValue)LevelBasedValue.constant((float)2.5f), (LevelBasedValue)LevelBasedValue.perLevel((float)2.5f, (float)0.5f), (LevelBasedValue)LevelBasedValue.constant((float)0.0f), (LevelBasedValue)LevelBasedValue.perLevel((float)1.0f))).build(POISONING.location()));
        context.register(FEARLESS, (Object)Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.SHARP_WEAPON_ENCHANTABLE), (HolderSet)items.getOrThrow(ItemTags.SWORD_ENCHANTABLE), (int)10, (int)2, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)11), (Enchantment.Cost)Enchantment.dynamicCost((int)21, (int)11), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withEffect(EnchantmentEffectComponents.KNOCKBACK, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)0.5f))).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, (Object)new PushTowardsEntity((LevelBasedValue)LevelBasedValue.constant((float)0.4f), (LevelBasedValue)LevelBasedValue.perLevel((float)0.4f, (float)0.3f))).build(FEARLESS.location()));
        context.register(SOUL_SNATCHER, (Object)Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ESTags.Items.CHAIN_OF_SOULS_ENCHANTABLE), (int)10, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)25), (Enchantment.Cost)Enchantment.dynamicCost((int)75, (int)25), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withEffect(EnchantmentEffectComponents.DAMAGE, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)0.5f)), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.DIRECT_ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().of(ESEntities.CHAIN_OF_SOULS.get()))).build(SOUL_SNATCHER.location()));
        context.register(TEARING, (Object)Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ESTags.Items.PUNGENCY_FRUIT_SPEAR_ENCHANTABLE), (HolderSet)items.getOrThrow(ESTags.Items.PUNGENCY_FRUIT_SPEAR_ENCHANTABLE), (int)10, (int)1, (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)25), (Enchantment.Cost)Enchantment.dynamicCost((int)75, (int)25), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, (Object)new ApplyMobEffect((HolderSet)HolderSet.direct((Holder[])new Holder[]{ESMobEffects.TEARY.asHolder()}), (LevelBasedValue)LevelBasedValue.constant((float)2.5f), (LevelBasedValue)LevelBasedValue.perLevel((float)2.5f, (float)0.5f), (LevelBasedValue)LevelBasedValue.constant((float)0.0f), (LevelBasedValue)LevelBasedValue.constant((float)0.0f)), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.DIRECT_ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().of(ESEntities.PUNGENCY_FRUIT_SPEAR.get()))).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.DAMAGING_ENTITY, (Object)new SpawnParticlesEffect((ParticleOptions)ESSmokeParticleOptions.PUNGENCY_FRUIT, SpawnParticlesEffect.inBoundingBox(), SpawnParticlesEffect.inBoundingBox(), SpawnParticlesEffect.fixedVelocity((FloatProvider)ConstantFloat.of((float)0.0f)), SpawnParticlesEffect.fixedVelocity((FloatProvider)ConstantFloat.of((float)0.0f)), (FloatProvider)ConstantFloat.of((float)0.0f)), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.DIRECT_ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().of(ESEntities.PUNGENCY_FRUIT_SPEAR.get()))).build(TEARING.location()));
        context.register(OVERHEAT, (Object)Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ESTags.Items.SEEDS_LAUNCHER_ENCHANTABLE), (HolderSet)items.getOrThrow(ESTags.Items.SEEDS_LAUNCHER_ENCHANTABLE), (int)5, (int)2, (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)11), (Enchantment.Cost)Enchantment.dynamicCost((int)30, (int)11), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withEffect(EnchantmentEffectComponents.PROJECTILE_SPAWNED, (Object)new Ignite((LevelBasedValue)LevelBasedValue.perLevel((float)100.0f))).exclusiveWith((HolderSet)enchantments.getOrThrow(ESTags.Enchantments.SEEDS_LAUNCHER_EXCLUSIVE)).build(OVERHEAT.location()));
        context.register(GLACIAL_SOWING, (Object)Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ESTags.Items.SEEDS_LAUNCHER_ENCHANTABLE), (HolderSet)items.getOrThrow(ESTags.Items.SEEDS_LAUNCHER_ENCHANTABLE), (int)5, (int)2, (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)11), (Enchantment.Cost)Enchantment.dynamicCost((int)30, (int)11), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, (Object)new Freeze((LevelBasedValue)LevelBasedValue.perLevel((float)4.0f)), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.DIRECT_ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().of(ESEntities.SHOT_SEEDS.get()))).exclusiveWith((HolderSet)enchantments.getOrThrow(ESTags.Enchantments.SEEDS_LAUNCHER_EXCLUSIVE)).build(GLACIAL_SOWING.location()));
        context.register(FERTILE, (Object)Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ESTags.Items.SEEDS_LAUNCHER_ENCHANTABLE), (HolderSet)items.getOrThrow(ESTags.Items.SEEDS_LAUNCHER_ENCHANTABLE), (int)2, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)11), (Enchantment.Cost)Enchantment.dynamicCost((int)30, (int)11), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withEffect(EnchantmentEffectComponents.PROJECTILE_COUNT, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)2.0f))).build(FERTILE.location()));
    }

    public static ResourceKey<Enchantment> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)EternalStarlight.id(name));
    }
}

