/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.data;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.data.ESBiomeData;
import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.world.gen.system.BiomeData;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.DataTransformer;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.MergedIterationTransformer;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.biome.AddBeachesTransformer;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.biome.AddBiomesTransformer;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.biome.AddOceanTransformer;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.biome.AddRiversTransformer;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.biome.AddTheAbyssTransformer;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.biome.AddTransitionBiomesTransformer;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.biome.AssimilateBiomesTransformer;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.biome.DuplicateSizeTransformer;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.biome.FinalizeBiomesTransformer;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.biome.RandomizeBiomesTransformer;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.height.FinalizeHeightsTransformer;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.height.NoiseHeightTransformer;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.height.SmoothHeightsTransformer;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class ESDataTransformers {
    public static final ResourceKey<DataTransformer> DUPLICATE = ESDataTransformers.create("duplicate");
    public static final ResourceKey<DataTransformer> FINALIZE_BIOMES = ESDataTransformers.create("finalize_biomes");
    public static final ResourceKey<DataTransformer> APPLY_BIOMES = ESDataTransformers.create("apply_biomes");
    public static final ResourceKey<DataTransformer> ADD_OCEAN = ESDataTransformers.create("add_ocean");
    public static final ResourceKey<DataTransformer> ADD_BEACHES = ESDataTransformers.create("add_beaches");
    public static final ResourceKey<DataTransformer> ADD_RIVERS_AND_ABYSS = ESDataTransformers.create("add_rivers_and_abyss");
    public static final ResourceKey<DataTransformer> ADD_TRANSITIONS = ESDataTransformers.create("add_transitions");
    public static final ResourceKey<DataTransformer> RANDOMIZE_BIOMES = ESDataTransformers.create("randomize_biomes");
    public static final ResourceKey<DataTransformer> ASSIMILATE_BIOMES = ESDataTransformers.create("assimilate_biomes");
    public static final ResourceKey<DataTransformer> ASSIMILATE_LONELY_BIOMES = ESDataTransformers.create("assimilate_lonely_biomes");
    public static final ResourceKey<DataTransformer> FINALIZE_HEIGHTS = ESDataTransformers.create("finalize_heights");
    public static final ResourceKey<DataTransformer> NOISE_HEIGHT = ESDataTransformers.create("noise_height");
    public static final ResourceKey<DataTransformer> SMOOTH_HEIGHTS_LARGE = ESDataTransformers.create("smooth_heights_large");
    public static final ResourceKey<DataTransformer> SMOOTH_HEIGHTS_SMALL = ESDataTransformers.create("smooth_heights_small");

    public static void bootstrap(BootstrapContext<DataTransformer> context) {
        HolderGetter data = context.lookup(ESRegistries.BIOME_DATA);
        context.register(DUPLICATE, (Object)new DuplicateSizeTransformer());
        context.register(FINALIZE_BIOMES, (Object)new FinalizeBiomesTransformer());
        context.register(APPLY_BIOMES, (Object)new AddBiomesTransformer(0.06, List.of(data.getOrThrow(ESBiomeData.STARLIGHT_FOREST), data.getOrThrow(ESBiomeData.STARLIGHT_DENSE_FOREST), data.getOrThrow(ESBiomeData.DARK_SWAMP), data.getOrThrow(ESBiomeData.STARLIGHT_PERMAFROST_FOREST), data.getOrThrow(ESBiomeData.SCARLET_FOREST), data.getOrThrow(ESBiomeData.CRYSTALLIZED_DESERT)), List.of(data.getOrThrow(ESBiomeData.STARLIT_SEA), data.getOrThrow(ESBiomeData.SPIRAL_KELP_FOREST), data.getOrThrow(ESBiomeData.LUSH_SHALLOW_SEA))));
        context.register(ADD_OCEAN, (Object)new AddOceanTransformer((Holder<BiomeData>)data.getOrThrow(ESBiomeData.STARLIT_SEA)));
        context.register(ADD_BEACHES, (Object)new AddBeachesTransformer((Holder<BiomeData>)data.getOrThrow(ESBiomeData.WARM_SHORE)));
        context.register(ADD_RIVERS_AND_ABYSS, (Object)new MergedIterationTransformer((HolderSet<DataTransformer>)HolderSet.direct((Holder[])new Holder[]{Holder.direct((Object)new AddRiversTransformer(List.of(new AddRiversTransformer.RiverWithOffset((Holder<BiomeData>)data.getOrThrow(ESBiomeData.SHIMMER_RIVER), 0.03f, 0), new AddRiversTransformer.RiverWithOffset((Holder<BiomeData>)data.getOrThrow(ESBiomeData.ETHER_RIVER), 0.05f, 4096)))), Holder.direct((Object)new AddTheAbyssTransformer((Holder<BiomeData>)data.getOrThrow(ESBiomeData.THE_ABYSS)))})));
        context.register(ADD_TRANSITIONS, (Object)new AddTransitionBiomesTransformer(List.of(new AddTransitionBiomesTransformer.BiomeWithTransition((Holder<BiomeData>)data.getOrThrow(ESBiomeData.SHIMMER_RIVER), (Holder<BiomeData>)data.getOrThrow(ESBiomeData.SHIMMER_RIVER_TRANSITION)), new AddTransitionBiomesTransformer.BiomeWithTransition((Holder<BiomeData>)data.getOrThrow(ESBiomeData.THE_ABYSS), (Holder<BiomeData>)data.getOrThrow(ESBiomeData.THE_ABYSS_TRANSITION)), new AddTransitionBiomesTransformer.BiomeWithTransition((Holder<BiomeData>)data.getOrThrow(ESBiomeData.ETHER_RIVER), (Holder<BiomeData>)data.getOrThrow(ESBiomeData.TORREYA_FOREST)))));
        context.register(RANDOMIZE_BIOMES, (Object)new RandomizeBiomesTransformer());
        context.register(ASSIMILATE_BIOMES, (Object)new AssimilateBiomesTransformer(false));
        context.register(ASSIMILATE_LONELY_BIOMES, (Object)new AssimilateBiomesTransformer(true));
        context.register(FINALIZE_HEIGHTS, (Object)new FinalizeHeightsTransformer());
        context.register(NOISE_HEIGHT, (Object)new NoiseHeightTransformer());
        context.register(SMOOTH_HEIGHTS_LARGE, (Object)new SmoothHeightsTransformer(6));
        context.register(SMOOTH_HEIGHTS_SMALL, (Object)new SmoothHeightsTransformer(4));
    }

    public static ResourceKey<DataTransformer> create(String name) {
        return ResourceKey.create(ESRegistries.DATA_TRANSFORMER, (ResourceLocation)EternalStarlight.id(name));
    }
}

