/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.data;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.data.ESConfiguredWorldCarvers;
import cn.leolezury.eternalstarlight.common.data.ESPlacedFeatures;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class ESBiomes {
    public static final ResourceKey<Biome> STARLIGHT_FOREST = ESBiomes.create("starlight_forest");
    public static final ResourceKey<Biome> STARLIGHT_DENSE_FOREST = ESBiomes.create("starlight_dense_forest");
    public static final ResourceKey<Biome> STARLIGHT_PERMAFROST_FOREST = ESBiomes.create("starlight_permafrost_forest");
    public static final ResourceKey<Biome> DARK_SWAMP = ESBiomes.create("dark_swamp");
    public static final ResourceKey<Biome> SCARLET_FOREST = ESBiomes.create("scarlet_forest");
    public static final ResourceKey<Biome> TORREYA_FOREST = ESBiomes.create("torreya_forest");
    public static final ResourceKey<Biome> CRYSTALLIZED_DESERT = ESBiomes.create("crystallized_desert");
    public static final ResourceKey<Biome> SHIMMER_RIVER = ESBiomes.create("shimmer_river");
    public static final ResourceKey<Biome> ETHER_RIVER = ESBiomes.create("ether_river");
    public static final ResourceKey<Biome> STARLIT_SEA = ESBiomes.create("starlit_sea");
    public static final ResourceKey<Biome> SPIRAL_KELP_FOREST = ESBiomes.create("spiral_kelp_forest");
    public static final ResourceKey<Biome> LUSH_SHALLOW_SEA = ESBiomes.create("lush_shallow_sea");
    public static final ResourceKey<Biome> THE_ABYSS = ESBiomes.create("the_abyss");
    public static final ResourceKey<Biome> WARM_SHORE = ESBiomes.create("warm_shore");
    public static final Music MUSIC_TRANQUILITY = new Music(ESSoundEvents.MUSIC_DIMENSION.asHolder(), 1200, 12000, false);
    public static final Music MUSIC_FOREST = new Music(ESSoundEvents.MUSIC_BIOME_STARLIGHT_FOREST.asHolder(), 1200, 12000, false);
    public static final Music MUSIC_PERMAFROST_FOREST = new Music(ESSoundEvents.MUSIC_BIOME_STARLIGHT_PERMAFROST_FOREST.asHolder(), 1200, 12000, false);
    public static final Music MUSIC_SWAMP = new Music(ESSoundEvents.MUSIC_BIOME_DARK_SWAMP.asHolder(), 1200, 12000, false);
    public static final Music MUSIC_SCARLET_FOREST = new Music(ESSoundEvents.MUSIC_BIOME_SCARLET_FOREST.asHolder(), 1200, 12000, false);
    public static final Music MUSIC_TORREYA_FOREST = new Music(ESSoundEvents.MUSIC_BIOME_TORREYA_FOREST.asHolder(), 1200, 12000, false);
    public static final Music MUSIC_DESERT = new Music(ESSoundEvents.MUSIC_BIOME_CRYSTALLIZED_DESERT.asHolder(), 1200, 12000, false);
    public static final Music MUSIC_STARLIT_SEA = new Music(ESSoundEvents.MUSIC_BIOME_STARLIT_SEA.asHolder(), 1200, 12000, false);
    public static final Music MUSIC_THE_ABYSS = new Music(ESSoundEvents.MUSIC_BIOME_THE_ABYSS.asHolder(), 1200, 12000, false);

    public static void bootstrap(BootstrapContext<Biome> context) {
        HolderGetter featureHolderGetter = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter carverHolderGetter = context.lookup(Registries.CONFIGURED_CARVER);
        context.register(STARLIGHT_FOREST, (Object)ESBiomes.baseBiomeBuilder(ESBiomes.baseEffectsBuilder().backgroundMusic(MUSIC_FOREST), ESBiomes.baseLushSpawnBuilder(), ESBiomes.forestGenSettings((HolderGetter<PlacedFeature>)featureHolderGetter, carverHolderGetter)).build());
        context.register(STARLIGHT_DENSE_FOREST, (Object)ESBiomes.baseBiomeBuilder(ESBiomes.baseEffectsBuilder().backgroundMusic(MUSIC_FOREST), ESBiomes.baseLushSpawnBuilder(), ESBiomes.denseForestGenSettings((HolderGetter<PlacedFeature>)featureHolderGetter, carverHolderGetter)).build());
        context.register(STARLIGHT_PERMAFROST_FOREST, (Object)ESBiomes.baseBiomeBuilder(ESBiomes.baseEffectsBuilder().fogColor(0xE1E1FF).skyColor(0xE1E1FF).grassColorOverride(0xE1E1FF).backgroundMusic(MUSIC_PERMAFROST_FOREST), ESBiomes.permafrostForestSpawns(), ESBiomes.permafrostForestGenSettings((HolderGetter<PlacedFeature>)featureHolderGetter, carverHolderGetter)).temperature(-0.3f).temperatureAdjustment(Biome.TemperatureModifier.FROZEN).build());
        context.register(DARK_SWAMP, (Object)ESBiomes.baseBiomeBuilder(ESBiomes.baseEffectsBuilder().fogColor(5250640).foliageColorOverride(7890120).skyColor(5250640).grassColorOverride(4075082).waterColor(7428526).waterFogColor(7428526).backgroundMusic(MUSIC_SWAMP), ESBiomes.swampSpawns(), ESBiomes.swampGenSettings((HolderGetter<PlacedFeature>)featureHolderGetter, carverHolderGetter)).build());
        context.register(SCARLET_FOREST, (Object)ESBiomes.baseBiomeBuilder(ESBiomes.baseEffectsBuilder().fogColor(10313569).foliageColorOverride(10313569).skyColor(10313569).grassColorOverride(10313569).backgroundMusic(MUSIC_SCARLET_FOREST), ESBiomes.baseLushSpawnBuilder(), ESBiomes.scarletForestGenSettings((HolderGetter<PlacedFeature>)featureHolderGetter, carverHolderGetter)).build());
        context.register(TORREYA_FOREST, (Object)ESBiomes.baseBiomeBuilder(ESBiomes.baseEffectsBuilder().fogColor(7229604).foliageColorOverride(7229604).skyColor(7229604).grassColorOverride(7229604).backgroundMusic(MUSIC_TORREYA_FOREST), ESBiomes.baseLushSpawnBuilder(), ESBiomes.torreyaForestGenSettings((HolderGetter<PlacedFeature>)featureHolderGetter, carverHolderGetter)).build());
        context.register(CRYSTALLIZED_DESERT, (Object)ESBiomes.baseBiomeBuilder(ESBiomes.baseEffectsBuilder().fogColor(8349826).foliageColorOverride(8349826).skyColor(8349826).grassColorOverride(8349826).backgroundMusic(MUSIC_DESERT), ESBiomes.desertSpawns(), ESBiomes.desertGenSettings((HolderGetter<PlacedFeature>)featureHolderGetter, carverHolderGetter)).hasPrecipitation(false).temperature(2.0f).build());
        context.register(SHIMMER_RIVER, (Object)ESBiomes.baseBiomeBuilder(ESBiomes.baseEffectsBuilder(), ESBiomes.riverSpawns(), ESBiomes.riverGenSettings((HolderGetter<PlacedFeature>)featureHolderGetter, carverHolderGetter)).build());
        context.register(ETHER_RIVER, (Object)ESBiomes.baseBiomeBuilder(ESBiomes.baseEffectsBuilder().fogColor(0xDBFFDB).foliageColorOverride(0xDBFFDB).skyColor(0xDBFFDB).grassColorOverride(0xDBFFDB).waterColor(0xDBFFDB).waterFogColor(0xDBFFDB), ESBiomes.baseSpawnBuilder(), ESBiomes.etherRiverGenSettings((HolderGetter<PlacedFeature>)featureHolderGetter, carverHolderGetter)).build());
        context.register(STARLIT_SEA, (Object)ESBiomes.baseBiomeBuilder(ESBiomes.baseEffectsBuilder().backgroundMusic(MUSIC_STARLIT_SEA), ESBiomes.baseAquaticSpawnBuilder(), ESBiomes.oceanGenSettings((HolderGetter<PlacedFeature>)featureHolderGetter, carverHolderGetter)).build());
        context.register(SPIRAL_KELP_FOREST, (Object)ESBiomes.baseBiomeBuilder(ESBiomes.baseEffectsBuilder().backgroundMusic(MUSIC_STARLIT_SEA).waterColor(7883610).waterFogColor(1576722), ESBiomes.baseAquaticSpawnBuilder(), ESBiomes.spiralKelpForestGenSettings((HolderGetter<PlacedFeature>)featureHolderGetter, carverHolderGetter)).build());
        context.register(LUSH_SHALLOW_SEA, (Object)ESBiomes.baseBiomeBuilder(ESBiomes.baseEffectsBuilder().backgroundMusic(MUSIC_STARLIT_SEA).waterColor(6124624).waterFogColor(4737072), ESBiomes.baseAquaticSpawnBuilder(), ESBiomes.lushShallowSeaGenSettings((HolderGetter<PlacedFeature>)featureHolderGetter, carverHolderGetter)).build());
        context.register(THE_ABYSS, (Object)ESBiomes.baseBiomeBuilder(ESBiomes.baseEffectsBuilder(false).waterFogColor(3409191).backgroundMusic(MUSIC_THE_ABYSS), ESBiomes.theAbyssSpawns(), ESBiomes.theAbyssGenSettings((HolderGetter<PlacedFeature>)featureHolderGetter, carverHolderGetter)).build());
        context.register(WARM_SHORE, (Object)ESBiomes.baseBiomeBuilder(ESBiomes.baseEffectsBuilder(), ESBiomes.baseLushSpawnBuilder(), ESBiomes.baseLandGenSettings((HolderGetter<PlacedFeature>)featureHolderGetter, carverHolderGetter)).build());
    }

    private static Biome.BiomeBuilder baseBiomeBuilder(BiomeSpecialEffects.Builder specialEffects, MobSpawnSettings.Builder mobSpawnSettings, BiomeGenerationSettings.Builder genSettings) {
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.5f).downfall(0.5f).specialEffects(specialEffects.build()).mobSpawnSettings(mobSpawnSettings.build()).generationSettings(genSettings.build()).temperatureAdjustment(Biome.TemperatureModifier.NONE);
    }

    private static BiomeSpecialEffects.Builder baseEffectsBuilder() {
        return ESBiomes.baseEffectsBuilder(true);
    }

    private static BiomeSpecialEffects.Builder baseEffectsBuilder(boolean ambientParticle) {
        BiomeSpecialEffects.Builder builder = new BiomeSpecialEffects.Builder().fogColor(5195923).foliageColorOverride(5195923).grassColorOverride(5195923).waterColor(6187416).waterFogColor(0x121223).skyColor(5658761).backgroundMusic(MUSIC_TRANQUILITY);
        if (ambientParticle) {
            builder.ambientParticle(new AmbientParticleSettings((ParticleOptions)ESParticles.STARLIGHT.get(), 0.001f));
        }
        return builder;
    }

    private static MobSpawnSettings.Builder baseSpawnBuilder() {
        return new MobSpawnSettings.Builder().creatureGenerationProbability(0.2f).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(ESEntities.NIGHTFALL_SPIDER.get(), 20, 1, 2)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(ESEntities.LONESTAR_SKELETON.get(), 20, 1, 2)).addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.BAT, 2, 1, 2)).addMobCharge(ESEntities.NIGHTFALL_SPIDER.get(), 1.0, 0.15).addMobCharge(ESEntities.LONESTAR_SKELETON.get(), 1.0, 0.15);
    }

    private static MobSpawnSettings.Builder baseLushSpawnBuilder() {
        return ESBiomes.baseSpawnBuilder().addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ESEntities.ENT.get(), 30, 1, 2)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ESEntities.RATLIN.get(), 24, 1, 3)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ESEntities.SHADOW_SNAIL.get(), 18, 1, 2));
    }

    private static MobSpawnSettings.Builder baseAquaticSpawnBuilder() {
        return ESBiomes.baseSpawnBuilder().addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(ESEntities.ROOKFISH.get(), 16, 2, 4));
    }

    private static MobSpawnSettings.Builder permafrostForestSpawns() {
        return ESBiomes.baseLushSpawnBuilder().addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ESEntities.YETI.get(), 20, 3, 6)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ESEntities.AURORA_DEER.get(), 16, 3, 6));
    }

    private static MobSpawnSettings.Builder swampSpawns() {
        return ESBiomes.baseLushSpawnBuilder().addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ESEntities.ZOMBIFIED_RATLIN.get(), 24, 1, 3)).addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(ESEntities.SHIMMER_LACEWING.get(), 10, 1, 2)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.WITCH, 7, 1, 2)).addMobCharge(EntityType.WITCH, 1.0, 0.15);
    }

    private static MobSpawnSettings.Builder desertSpawns() {
        return ESBiomes.baseSpawnBuilder().addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(ESEntities.CRYSTALLIZED_MOTH.get(), 10, 1, 4)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(ESEntities.GLEECH.get(), 10, 1, 3)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(ESEntities.THIRST_WALKER.get(), 10, 1, 2)).addMobCharge(ESEntities.GLEECH.get(), 1.0, 0.15).addMobCharge(ESEntities.THIRST_WALKER.get(), 1.0, 0.15);
    }

    private static MobSpawnSettings.Builder riverSpawns() {
        return ESBiomes.baseAquaticSpawnBuilder().addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(ESEntities.SHIMMER_LACEWING.get(), 20, 1, 2));
    }

    private static MobSpawnSettings.Builder theAbyssSpawns() {
        return ESBiomes.baseAquaticSpawnBuilder().addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(ESEntities.LUMINOFISH.get(), 20, 3, 6)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(ESEntities.LUMINARIS.get(), 16, 3, 6)).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(ESEntities.TWILIGHT_GAZE.get(), 10, 3, 6));
    }

    public static BiomeGenerationSettings.Builder baseLandGenSettings(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        return ESBiomes.baseLandGenSettings(featureGetter, carverGetter, true, true);
    }

    public static BiomeGenerationSettings.Builder baseLandGenSettings(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, boolean grass, boolean defaultOres) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        if (grass) {
            BiomeDefaultFeatures.addSavannaGrass((BiomeGenerationSettings.Builder)builder);
            BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)builder);
        }
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)builder);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.WATERSIDE_VEGETATION);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.CAVE_MOSS);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.CAVE_MOSS_VEIN);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.BOULDERSHROOM);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, ESPlacedFeatures.STELLAGMITE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.STONE_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.DEEPSLATE_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.NIGHTFALL_DIRT_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.GLOWING_GRIMSTONE_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.GLOWING_VOIDSTONE_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.UPPER_STARLIT_DIAMOND_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.LOWER_STARLIT_DIAMOND_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.UPPER_REDSTONE_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.LOWER_REDSTONE_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.UPPER_SALTPETER_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.LOWER_SALTPETER_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.UPPER_ATALPHAITE_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.LOWER_ATALPHAITE_ORE);
        builder.addFeature(GenerationStep.Decoration.LAKES, ESPlacedFeatures.HOT_SPRING);
        builder.addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, ESPlacedFeatures.FINAL_MODIFICATION);
        builder.addCarver(GenerationStep.Carving.AIR, ESConfiguredWorldCarvers.CAVES);
        return builder;
    }

    public static BiomeGenerationSettings.Builder baseAquaticGenSettings(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)builder);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.CAVE_MOSS);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.CAVE_MOSS_VEIN);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.BOULDERSHROOM);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.STONE_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.DEEPSLATE_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.NIGHTFALL_DIRT_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.SAND_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.GLOWING_GRIMSTONE_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.GLOWING_VOIDSTONE_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.UPPER_STARLIT_DIAMOND_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.LOWER_STARLIT_DIAMOND_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.UPPER_REDSTONE_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.LOWER_REDSTONE_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.UPPER_SALTPETER_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.LOWER_SALTPETER_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.UPPER_ATALPHAITE_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.LOWER_ATALPHAITE_ORE);
        builder.addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, ESPlacedFeatures.FINAL_MODIFICATION);
        builder.addCarver(GenerationStep.Carving.AIR, ESConfiguredWorldCarvers.CAVES);
        return builder;
    }

    private static BiomeGenerationSettings.Builder forestGenSettings(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder builder = ESBiomes.baseLandGenSettings(featureGetter, carverGetter);
        builder.addFeature(GenerationStep.Decoration.RAW_GENERATION, ESPlacedFeatures.FALLEN_LUNAR_LOG);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.STARLIGHT_FOREST);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.FOREST_VEGETATION);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.CAVE_VINE);
        builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, ESPlacedFeatures.STONE_SPIKE);
        return builder;
    }

    private static BiomeGenerationSettings.Builder denseForestGenSettings(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder builder = ESBiomes.baseLandGenSettings(featureGetter, carverGetter);
        builder.addFeature(GenerationStep.Decoration.RAW_GENERATION, ESPlacedFeatures.FALLEN_LUNAR_LOG);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.DENSE_FOREST);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.FOREST_VEGETATION);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.CAVE_VINE);
        return builder;
    }

    private static BiomeGenerationSettings.Builder permafrostForestGenSettings(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder builder = ESBiomes.baseLandGenSettings(featureGetter, carverGetter, true, false);
        builder.addFeature(GenerationStep.Decoration.RAW_GENERATION, ESPlacedFeatures.FALLEN_NORTHLAND_LOG);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, ESPlacedFeatures.GLACITE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, ESPlacedFeatures.ICICLE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, ESPlacedFeatures.HANGING_ICICLE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, ESPlacedFeatures.ASHEN_SNOW);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.PERMAFROST_FOREST);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.PERMAFROST_FOREST_VEGETATION);
        return builder;
    }

    private static BiomeGenerationSettings.Builder swampGenSettings(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder builder = ESBiomes.baseLandGenSettings(featureGetter, carverGetter);
        builder.addFeature(GenerationStep.Decoration.RAW_GENERATION, ESPlacedFeatures.FALLEN_STARLIGHT_MANGROVE_LOG);
        builder.addFeature(GenerationStep.Decoration.LAKES, ESPlacedFeatures.SWAMP_WATER);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.SWAMP_SILVER_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.UPPER_MALARITE_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.LOWER_MALARITE_ORE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ESPlacedFeatures.GLOWING_NIGHTFALL_MUD_ORE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.SWAMP_FOREST);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.SWAMP_VEGETATION);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.WATER_SURFACE_VEGETATION);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.UNDERGROUND_SWAMP_VEGETATION);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.HANGING_FANTAGRASS);
        return builder;
    }

    private static BiomeGenerationSettings.Builder scarletForestGenSettings(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder builder = ESBiomes.baseLandGenSettings(featureGetter, carverGetter);
        builder.addFeature(GenerationStep.Decoration.RAW_GENERATION, ESPlacedFeatures.FALLEN_SCARLET_LOG);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_PUMPKIN);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.SCARLET_FOREST_VEGETATION);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.SCARLET_FOREST);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.SCARLET_LEAVES_PILE);
        return builder;
    }

    private static BiomeGenerationSettings.Builder torreyaForestGenSettings(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder builder = ESBiomes.baseLandGenSettings(featureGetter, carverGetter);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.TORREYA_FOREST_VEGETATION);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.TORREYA_FOREST);
        return builder;
    }

    private static BiomeGenerationSettings.Builder desertGenSettings(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder builder = ESBiomes.baseLandGenSettings(featureGetter, carverGetter, false, true);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, ESPlacedFeatures.STARLIGHT_CRYSTAL);
        builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, ESPlacedFeatures.STARLIGHT_CRYSTAL_SURFACE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.DESERT_VEGETATION);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.DEAD_LUNAR_TREE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.LUNARIS_CACTUS);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.CRYSTAL_CAVES_VEGETATION);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.RED_CRYSTAL_MOSS_PATCH);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.BLUE_CRYSTAL_MOSS_PATCH);
        return builder;
    }

    private static BiomeGenerationSettings.Builder riverGenSettings(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder builder = ESBiomes.baseAquaticGenSettings(featureGetter, carverGetter);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.WATER_SURFACE_VEGETATION);
        return builder;
    }

    private static BiomeGenerationSettings.Builder etherRiverGenSettings(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder builder = ESBiomes.baseAquaticGenSettings(featureGetter, carverGetter);
        builder.addFeature(GenerationStep.Decoration.RAW_GENERATION, ESPlacedFeatures.THIOQUARTZ_GEODE);
        return builder;
    }

    private static BiomeGenerationSettings.Builder oceanGenSettings(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder builder = ESBiomes.baseAquaticGenSettings(featureGetter, carverGetter);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.ORBFLORA);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.OCEAN_VEGETATION);
        return builder;
    }

    private static BiomeGenerationSettings.Builder spiralKelpForestGenSettings(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder builder = ESBiomes.baseAquaticGenSettings(featureGetter, carverGetter);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.SPIRAL_KELP);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.SEA_ROSA);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.SPIRAL_KELP_FOREST_VEGETATION);
        return builder;
    }

    private static BiomeGenerationSettings.Builder lushShallowSeaGenSettings(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder builder = ESBiomes.baseAquaticGenSettings(featureGetter, carverGetter);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.LUMENSTEM);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.JINGLESTEM_FOREST);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.LUSH_SHALLOW_SEA_VEGETATION);
        return builder;
    }

    private static BiomeGenerationSettings.Builder theAbyssGenSettings(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder builder = ESBiomes.baseAquaticGenSettings(featureGetter, carverGetter);
        builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, ESPlacedFeatures.ABYSSLATE_PATCH);
        builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, ESPlacedFeatures.THERMABYSSLATE_PATCH);
        builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, ESPlacedFeatures.CRYOBYSSLATE_PATCH);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.ABYSSAL_KELP);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.ORBFLORA);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.VELVETUMOSS);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ESPlacedFeatures.RED_VELVETUMOSS);
        return builder;
    }

    public static ResourceKey<Biome> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)EternalStarlight.id(name));
    }
}

