/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.config;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;

public class ESConfig {
    public static final Path CONFIG_PATH = ESPlatform.INSTANCE.getConfigDir().resolve("eternal_starlight.json");
    public static ESConfig INSTANCE = new ESConfig();
    public boolean enablePortalShader = true;
    public boolean enableScreenShake = true;
    public float aethersentMeteorDropRate = 5.0E-4f;
    public boolean laserBeamBreakBlocks = true;
    public int mobMaxTearyTicks = 200;
    public MobsConfig mobsConfig = new MobsConfig();
    public ItemsConfig itemsConfig = new ItemsConfig();

    public static void load() {
        Gson gson = new GsonBuilder().setLenient().setPrettyPrinting().create();
        File file = CONFIG_PATH.toFile();
        if (file.exists()) {
            try (FileReader fileReader = new FileReader(file);
                 JsonReader reader = new JsonReader((Reader)fileReader);){
                INSTANCE = (ESConfig)gson.fromJson(reader, ESConfig.class);
                ESConfig.write(gson, file, INSTANCE);
            }
            catch (IOException e) {
                EternalStarlight.LOGGER.error("Error while loading config");
            }
        } else {
            ESConfig.write(gson, file, INSTANCE);
        }
    }

    private static void write(Gson gson, File cfgFile, ESConfig config) {
        try (FileWriter writer = new FileWriter(cfgFile);){
            gson.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            EternalStarlight.LOGGER.error("Error while writing config");
        }
    }

    public static class MobsConfig {
        public final MobConfig boarwarf = new MobConfig(30.0, 10.0, true);
        public final AttackingMobConfig astralGolem = new AttackingMobConfig(100.0, 10.0, 10.0, 100.0, true);
        public final AttackingMobConfig gleech = new AttackingMobConfig(8.0, 0.0, 1.0, 16.0, true);
        public final AttackingMobConfig lonestarSkeleton = new AttackingMobConfig(20.0, 0.0, 3.2, 16.0, true);
        public final AttackingMobConfig nightfallSpider = new AttackingMobConfig(10.0, 0.0, 2.0, 16.0, true);
        public final AttackingMobConfig thirstWalker = new AttackingMobConfig(40.0, 0.0, 4.5, 32.0, true);
        public final CreteorConfig creteor = new CreteorConfig(15.0, 0.0, 5.0, 48.0, true, 0.7);
        public final AttackingMobConfig tinyCreteor = new AttackingMobConfig(5.0, 0.0, 2.0, 48.0, true);
        public final AttackingMobConfig stranghoul = new AttackingMobConfig(40.0, 2.0, 2.0, 32.0, true);
        public final MobConfig ent = new MobConfig(10.0, 0.0, true);
        public final MobConfig ratlin = new MobConfig(15.0, 0.0, true);
        public final AttackingMobConfig zombifiedRatlin = new AttackingMobConfig(20.0, 2.0, 3.0, 35.0, true);
        public final MobConfig shadowSnail = new MobConfig(8.0, 6.0, true);
        public final MobConfig yeti = new MobConfig(20.0, 0.0, true);
        public final AttackingMobConfig auroraDeer = new AttackingMobConfig(20.0, 0.0, 3.0, 16.0, true);
        public final AttackingMobConfig crystallizedMoth = new AttackingMobConfig(20.0, 0.0, 1.5, 64.0, true);
        public final MobConfig shimmerLacewing = new MobConfig(5.0, 0.0, true);
        public final MobConfig starfireBird = new MobConfig(15.0, 0.0, true);
        public final MobConfig grimstoneGolem = new MobConfig(20.0, 0.0, true);
        public final MobConfig aethersentGolem = new MobConfig(40.0, 10.0, true);
        public final AttackingMobConfig luminofish = new AttackingMobConfig(3.0, 0.0, 3.0, 16.0, true);
        public final AttackingMobConfig luminaris = new AttackingMobConfig(3.0, 0.0, 3.0, 64.0, true);
        public final AttackingMobConfig twilightGaze = new AttackingMobConfig(10.0, 0.0, 3.0, 16.0, true);
        public final AttackingMobConfig theGatekeeper = new AttackingMobConfig(175.0, 15.0, 5.0, 200.0, true);
        public final BossConfig starlightGolem = new BossConfig(220.0, 0.0, 1.0, 200.0, true);
        public final AttackingMobConfig freeze = new AttackingMobConfig(15.0, 0.0, 5.0, 32.0, true);
        public final BossConfig lunarMonstrosity = new BossConfig(200.0, 12.0, 1.0, 200.0, true);
        public final AttackingMobConfig tangled = new AttackingMobConfig(20.0, 0.0, 5.0, 64.0, true);
        public final AttackingMobConfig tangledSkull = new AttackingMobConfig(10.0, 0.0, 3.0, 64.0, true);
        public final BossConfig tangledHatred = new BossConfig(60.0, 5.0, 1.0, 100.0, true);

        public record MobConfig(double maxHealth, double armor, boolean canSpawn) {
        }

        public record AttackingMobConfig(double maxHealth, double armor, double attackDamage, double followRange, boolean canSpawn) {
        }

        public record CreteorConfig(double maxHealth, double armor, double attackDamage, double followRange, boolean canSpawn, double spawnChance) {
        }

        public record BossConfig(double maxHealth, double armor, double attackDamageScale, double followRange, boolean canSpawn) {
        }
    }

    public static class ItemsConfig {
        public final ChainOfSoulsConfig chainOfSouls = new ChainOfSoulsConfig(64.0, 2.0, 0.5);
        public final CrystalbornCatalystConfig crystalbornCatalyst = new CrystalbornCatalystConfig(128, 50);

        public record ChainOfSoulsConfig(double maxRange, double soulAbsorbDamage, double healPercentage) {
        }

        public record CrystalbornCatalystConfig(int maxRange, int energyPerShard) {
        }
    }
}

